/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.processor.validation.SignatureContainerFactory;
import de.intarsys.security.processor.validation.SignatureContainerResolverRegistry;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.UnknownSignatureContainer;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.BasicLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureContainerTools {
    public static final String ARG_SCAN_EMBEDDED_SIGNATURES = "scanEmbeddedSignatures";
    public static final String ARG_SCAN_DETACHED_SIGNATURES = "scanDetachedSignatures";
    public static final String ARG_SIGNATURECONTAINERS = "signatureContainers";
    private static final Logger Log = LoggerFactory.getLogger(SignatureContainerTools.class);

    public static Stream<Object> collectExternalSignatures(IDocument signedDocument, IArgs args) {
        return SignatureContainerResolverRegistry.get().getResolvers().stream().flatMap(resolver -> resolver.collectSignatureContainers(signedDocument, args));
    }

    public static ISignatureContainer createSignatureContainer(IDocument signatureDocument, IArgs args) throws IOException {
        return SignatureContainerFactory.get().createSignatureContainer(signatureDocument, args);
    }

    public static ISignatureContainer createSignatureContainer(IDocument signatureDocument, IDocument signedDocument, IArgs args) throws IOException {
        args = args.copy();
        args.put("signedDocument", (Object)signedDocument);
        ISignatureContainer signatureContainer = SignatureContainerFactory.get().createSignatureContainer(signatureDocument, args);
        return signatureContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ISignatureContainer createSignatureContainer(ILocator signatureLocator, IDocument signedDocument, IArgs args) throws IOException {
        IDocument signatureDocument = DocumentTools.createDocument((Object)signatureLocator);
        if (signatureDocument == null) {
            throw new IOException("signature container not found");
        }
        try {
            ISignatureContainer iSignatureContainer = SignatureContainerTools.createSignatureContainer(signatureDocument, signedDocument, args);
            return iSignatureContainer;
        }
        finally {
            signatureDocument.release(null);
        }
    }

    public static Stream<ISignatureContainer> createSignatureContainers(IDocument signedDocument, IArgs args) {
        Stream.Builder<Stream<ISignatureContainer>> result = Stream.builder();
        result.accept(SignatureContainerTools.createSignatureContainersEmbedded(signedDocument, args));
        result.accept(SignatureContainerTools.createSignatureContainersDetached(signedDocument, args));
        return result.build().flatMap(s -> s);
    }

    protected static Stream<ISignatureContainer> createSignatureContainersDetached(IDocument signedDocument, IArgs args) {
        boolean scanDetached;
        Stream.Builder<Stream<Object>> externalSignatureLocators = Stream.builder();
        List externalSignatureLocatorList = ArgTools.getList((IArgs)args, (String)ARG_SIGNATURECONTAINERS, null);
        boolean defaultExternalScan = true;
        if (externalSignatureLocatorList != null) {
            externalSignatureLocators.accept(externalSignatureLocatorList.stream());
            defaultExternalScan = false;
        }
        if (scanDetached = ArgTools.getBoolStrict((IArgs)args, (String)ARG_SCAN_DETACHED_SIGNATURES, (boolean)defaultExternalScan)) {
            externalSignatureLocators.accept(SignatureContainerTools.collectExternalSignatures(signedDocument, args));
        }
        return externalSignatureLocators.build().flatMap(s -> s).map(signatureReference -> SignatureContainerTools.toSignatureContainer(signatureReference, signedDocument, args));
    }

    protected static Stream<ISignatureContainer> createSignatureContainersEmbedded(IDocument signedDocument, IArgs args) {
        if (!ArgTools.getBoolStrict((IArgs)args, (String)ARG_SCAN_EMBEDDED_SIGNATURES, (boolean)true)) {
            return Stream.empty();
        }
        ISignatureContainer container = null;
        try {
            container = SignatureContainerTools.createSignatureContainer(signedDocument, args);
        }
        catch (IOException e) {
            Log.warn(e.getLocalizedMessage(), (Throwable)e);
            container = new UnknownSignatureContainer((Exception)e, true);
        }
        if (container == null) {
            return Stream.empty();
        }
        return Stream.of(container);
    }

    protected static ISignatureContainer toSignatureContainer(Object signatureReference, IDocument signedDocument, IArgs args) {
        ISignatureContainer container = null;
        if (signatureReference instanceof ISignatureContainer) {
            container = (ISignatureContainer)signatureReference;
        } else if (signatureReference instanceof IDocument) {
            IDocument signatureDocument = (IDocument)signatureReference;
            try {
                container = SignatureContainerTools.createSignatureContainer(signatureDocument, signedDocument, args);
            }
            catch (IOException e) {
                Log.warn(e.getLocalizedMessage(), (Throwable)e);
                container = new UnknownSignatureContainer((Exception)e, true);
            }
        } else {
            try {
                ILocator signatureLocator = LocatorTools.createLocator((Object)signatureReference, (ILocatorFactory)BasicLocatorFactory.get(), null);
                container = SignatureContainerTools.createSignatureContainer(signatureLocator, signedDocument, args);
            }
            catch (IOException e) {
                Log.warn(e.getLocalizedMessage(), (Throwable)e);
                container = new UnknownSignatureContainer((Exception)e, true);
            }
        }
        if (container == null) {
            container = new UnknownSignatureContainer((Exception)new IllegalArgumentException("no signature"), true);
        }
        return container;
    }

    private SignatureContainerTools() {
    }
}

