/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;

public final class ValidationProduct {
    public static final String LICPROP_ACCOUNT_VALIDATE = "account_validate";
    public static final String LICPROP_ACCOUNT_EMBED = "account_embed";
    protected static final String LICPROP_EMBED = "embed";
    protected static final String LICPROP_VALIDATE = "validate";
    protected static final String LICPROPVAL_TRUE = "true";

    public static final synchronized EnumLicenseState getLicenseStateEmbed() {
        return LicenseEnvironment.get().getLicensePropertyWithValueStateGlobal(LICPROP_EMBED, LICPROPVAL_TRUE);
    }

    public static final synchronized EnumLicenseState getLicenseStateValidate() {
        return LicenseEnvironment.get().getLicensePropertyWithValueStateGlobal(LICPROP_VALIDATE, LICPROPVAL_TRUE);
    }

    public static final boolean isAuthorizedEmbed() {
        if (!LicenseEnvironment.get().isAuthorizedProfessional()) {
            return false;
        }
        return ValidationProduct.getLicenseStateEmbed().isAuthorized() || ValidationProduct.getLicenseStateEmbed().isNA();
    }

    public static final boolean isAuthorizedValidate() {
        if (!LicenseEnvironment.get().isAuthorizedBasic()) {
            return false;
        }
        return !ValidationProduct.getLicenseStateValidate().isNotAuthorized();
    }

    public static void withdrawEmbed() throws LicenseException {
        LicenseEnvironment r = LicenseEnvironment.get();
        ILicenseAccount account = LicenseProduct.GLOBAL.getAccount(LICPROP_ACCOUNT_EMBED);
        account.reserve(1).commit();
    }

    public static void withdrawValidate() throws LicenseException {
        LicenseEnvironment r = LicenseEnvironment.get();
        ILicenseAccount account = LicenseProduct.GLOBAL.getAccount(LICPROP_ACCOUNT_VALIDATE);
        account.reserve(1).commit();
    }

    static {
        ILicenseAccount accountValidate = LicenseProduct.GLOBAL.getAccount(LICPROP_ACCOUNT_VALIDATE);
        accountValidate.setDefaultValueUnit(0, LicensePropertyUnit.ABSOLUTE);
        ILicenseAccount accountEmbed = LicenseProduct.GLOBAL.getAccount(LICPROP_ACCOUNT_EMBED);
        accountEmbed.setDefaultValueUnit(10, LicensePropertyUnit.PER_DAY);
    }
}

