/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation.standard;

import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.EnumValidityModel;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.processor.validation.ICertificateValidator;
import de.intarsys.security.processor.validation.standard.PACKAGE;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVTCertificate;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCertificateValidator
extends CommonProcessor<IVSCertificate>
implements ICertificateValidator {
    private static final Logger Log = LoggerFactory.getLogger(StandardCertificateValidator.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IX509Certificate certificate;
    private IVSCertificate certificateState;
    private EnumKeyPurpose keyPurpose;
    private Date referenceDate;
    private EnumValidityModel validityModel;

    public StandardCertificateValidator(IFactory factory) {
        super(factory);
    }

    protected IVSCertificate basicGetResult() {
        return this.getCertificateState();
    }

    protected void basicRun() {
        Log.debug("Enter: " + StandardCertificateValidator.class.getName(), (Object)"basicRun");
        if (this.getCertificate() == null) {
            Log.error(StandardCertificateValidator.class.getName(), (Object)"basicRun", (Object)"No certificate.");
            VSCertificate certificateState = new VSCertificate((IVTCertificate)null, 3);
            certificateState.addMessage(ValidationMessage.createError((String)Msg.getString("CommonCertificateValidator.errorCertificateNotAvailable", new Object[0])));
            this.certificateState = certificateState;
        } else {
            Log.trace(StandardCertificateValidator.class.getName(), (Object)"basicRun", (Object)"Got certificate, starting validation.");
            this.certificateState = this.doValidate();
        }
        this.ok();
        Log.debug("Exit: " + StandardCertificateValidator.class.getName(), (Object)"basicRun");
    }

    protected IVSCertificate doValidate() {
        Log.debug("Enter: " + StandardCertificateValidator.class.getName(), (Object)"doValidate");
        IValidationContext validationContext = ValidationEnvironment.get().getValidationContextFactory().createValidationContext(this.getArgs());
        ValidationParameters parameters = new ValidationParameters();
        parameters.setDateToTest(this.getReferenceDate());
        parameters.setValidityModel(this.getValidityModel());
        parameters.setKeyPurpose(this.getKeyPurpose());
        IVSCertificate result = validationContext.getCertificateValidator().validate(this.getCertificate(), (IValidationParameters)parameters);
        Log.debug("Exit: " + StandardCertificateValidator.class.getName(), (Object)"doValidate", (Object)result);
        return result;
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public IVSCertificate getCertificateState() {
        return this.certificateState;
    }

    public EnumKeyPurpose getKeyPurpose() {
        return this.keyPurpose;
    }

    public Date getReferenceDate() {
        return this.referenceDate;
    }

    public EnumValidityModel getValidityModel() {
        return this.validityModel;
    }

    public void setCertificate(IX509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setKeyPurpose(EnumKeyPurpose keyPurpose) {
        this.keyPurpose = keyPurpose;
    }

    public void setReferenceDate(Date referenceDate) {
        this.referenceDate = referenceDate;
    }

    public void setValidityModel(EnumValidityModel validityModel) {
        this.validityModel = validityModel;
    }
}

