/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation.standard;

import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.app.validation.ICertificatePathBuilder;
import de.intarsys.security.app.validation.IOCSPService;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.common.X509CertificatePath;
import de.intarsys.security.processor.validation.IOCSPValidator;
import de.intarsys.security.processor.validation.standard.PACKAGE;
import de.intarsys.security.standard.validation.VSOCSP;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOCSPValidator
extends CommonProcessor<IVSOCSP>
implements IOCSPValidator {
    private static final Logger Log = LoggerFactory.getLogger(StandardOCSPValidator.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IX509Certificate certificate;
    private IVSOCSP ocspState;
    private Date referenceDate;

    public StandardOCSPValidator(IFactory factory) {
        super(factory);
    }

    protected IVSOCSP basicGetResult() {
        return this.getOcspState();
    }

    protected void basicRun() {
        Log.debug("Enter: " + StandardOCSPValidator.class.getName(), (Object)"basicRun");
        if (this.getCertificate() == null) {
            Log.error(StandardOCSPValidator.class.getName(), (Object)"basicRun", (Object)"No certificate.");
            VSOCSP ocspState = new VSOCSP(3);
            ocspState.addMessage(ValidationMessage.createError((String)Msg.getString("StandardOCSPValidator.errorCertificateNotAvailable", new Object[0])));
            this.ocspState = ocspState;
        } else {
            Log.trace(StandardOCSPValidator.class.getName(), (Object)"basicRun", (Object)"Got certificate, starting validation.");
            this.ocspState = this.basicValidate();
        }
        this.ok();
        Log.debug("Exit: " + StandardOCSPValidator.class.getName(), (Object)"basicRun");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IVSOCSP basicValidate() {
        IX509CertificatePath certificatePath = this.getCertificatePath(this.getCertificate());
        IArgs contextArgs = this.getArgs().copy();
        IValidationContext previousContext = ValidationContext.getCurrent();
        IValidationContext context = ValidationEnvironment.get().getValidationContextFactory().createValidationContext(contextArgs);
        try {
            IVSOCSP ocspState;
            IOCSPService ocspService = context.getOCSPService();
            ValidationParameters parameters = new ValidationParameters();
            parameters.setDateToTest(this.getReferenceDate());
            IVSOCSP iVSOCSP = ocspState = ocspService.validateCertificate(this.getCertificate(), certificatePath, (IValidationParameters)parameters);
            return iVSOCSP;
        }
        finally {
            ValidationContext.setCurrent((IValidationContext)previousContext);
        }
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    protected IX509CertificatePath getCertificatePath(IX509Certificate certificate) {
        Args args = Args.create();
        args.put("stopOnIntermediateTrustAnchor", (Object)false);
        args.put("checkCRL", (Object)false);
        args.put("checkOCSP", (Object)false);
        IValidationContext validationContext = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)args);
        ICertificatePathBuilder pathBuilder = validationContext.getCertificatePathBuilder();
        ValidationParameters parameters = new ValidationParameters();
        IVSCertificatePath state = pathBuilder.buildCertificatePath(certificate, (IValidationParameters)parameters);
        if (state == null || state.getCertPath() == null) {
            return new X509CertificatePath(ListTools.with((Object[])new IX509Certificate[]{certificate}));
        }
        return state.getCertPath();
    }

    public IVSOCSP getOcspState() {
        return this.ocspState;
    }

    public Date getReferenceDate() {
        return this.referenceDate;
    }

    public void setCertificate(IX509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setReferenceDate(Date referenceDate) {
        this.referenceDate = referenceDate;
    }
}

