/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.IStateNodeVisitor;
import de.intarsys.security.validation.node.MessageCollector;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.StateNodeTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.string.StringTools;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CommonStateNode
implements IStateNode,
IPresentationSupport {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String name;
    private final IValidationState state;

    protected CommonStateNode(IValidationState pState) {
        this.state = pState;
    }

    protected CommonStateNode(String pName, IValidationState pState) {
        this.setName(pName);
        this.state = pState;
    }

    @Override
    public void accept(IStateNodeVisitor visitor) {
        visitor.visit(this);
    }

    protected String basicGetIconName() {
        return null;
    }

    @Override
    public List<IValidationMessage> getAllErrors() {
        return this.getAllMessages(0);
    }

    @Override
    public List<IValidationMessage> getAllInfos() {
        return this.getAllMessages(2);
    }

    @Override
    public List<IValidationMessage> getAllMessages() {
        MessageCollector messageCollector = new MessageCollector();
        messageCollector.setMinStateSeverity(0);
        messageCollector.setMaxStateSeverity(1);
        this.accept(messageCollector);
        return messageCollector.getMessages();
    }

    @Override
    public List<IValidationMessage> getAllMessages(int level) {
        MessageCollector messageCollector = new MessageCollector();
        messageCollector.setMinStateSeverity(0);
        messageCollector.setMaxStateSeverity(1);
        messageCollector.setMinMessageSeverity(level);
        messageCollector.setMaxMessageSeverity(level);
        this.accept(messageCollector);
        return messageCollector.getMessages();
    }

    @Override
    public List<IValidationMessage> getAllWarnings() {
        return this.getAllMessages(1);
    }

    public List<IStateNode> getAspectNodes() {
        return this.getState().getAspects().stream().map(aspect -> {
            IStateNode node = StateNodeTools.createNode(aspect.getState());
            if (StringTools.isEmpty((String)node.getLabel()) && node instanceof CommonStateNode) {
                ((CommonStateNode)node).setName(aspect.getName());
            }
            return node;
        }).collect(Collectors.toList());
    }

    @Override
    public List<IStateNode> getChildren() {
        return this.getAspectNodes();
    }

    protected String getDecoratedIcon(String stateIcon) {
        String baseName = this.basicGetIconName();
        if (baseName == null) {
            return stateIcon;
        }
        return stateIcon + "+" + baseName;
    }

    protected abstract String getDefaultName();

    public String getDescription() {
        return this.getLabel();
    }

    @Override
    public String getDisplayMessage() {
        String message = this.getPrimaryMessage();
        if (this.getState().isValid() && this.hasWarnings()) {
            return Msg.getString("CommonStateNode.DisplayMessageValidWarn", new Object[]{message});
        }
        if (this.getState().isUnknown()) {
            return Msg.getString("CommonStateNode.DisplayMessageUnknown", new Object[]{message});
        }
        return message;
    }

    protected String getIconInvalid() {
        return this.getDecoratedIcon("invalid");
    }

    public final String getIconName() {
        switch (this.getState().getState()) {
            case 3: {
                return this.getIconInvalid();
            }
            case -1: {
                return this.getIconUndefined();
            }
            case 2: {
                return this.getIconUnknown();
            }
            case 0: {
                if (this.hasWarnings()) {
                    return this.getIconWarning();
                }
                return this.getIconValid();
            }
        }
        return this.getIconUnknown();
    }

    protected String getIconUndefined() {
        return this.getDecoratedIcon("info");
    }

    protected String getIconUnknown() {
        return this.getDecoratedIcon("unknown");
    }

    protected String getIconValid() {
        return this.getDecoratedIcon("ok");
    }

    protected String getIconWarning() {
        return this.getDecoratedIcon("warning");
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getDefaultName();
        }
        return this.name;
    }

    protected String getPrimaryInvalidMessage() {
        return Msg.getString("CommonStateNode.PrimaryMessageInvalid", new Object[]{this.getName()});
    }

    @Override
    public final String getPrimaryMessage() {
        switch (this.getState().getState()) {
            case 3: {
                return this.getPrimaryInvalidMessage();
            }
            case -1: {
                return this.getPrimaryUndefinedMessage();
            }
            case 2: {
                return this.getPrimaryUnknownMessage();
            }
            case 0: {
                return this.getPrimaryValidMessage();
            }
        }
        return this.getPrimaryUnknownMessage();
    }

    protected String getPrimaryUndefinedMessage() {
        return Msg.getString("CommonStateNode.PrimaryMessageUndefined", new Object[]{this.getName()});
    }

    protected String getPrimaryUnknownMessage() {
        return Msg.getString("CommonStateNode.PrimaryMessageUnknown", new Object[]{this.getName()});
    }

    protected String getPrimaryValidMessage() {
        return Msg.getString("CommonStateNode.PrimaryMessageValid", new Object[]{this.getName()});
    }

    @Override
    public IValidationState getState() {
        return this.state;
    }

    public String getTip() {
        return this.getLabel();
    }

    @Override
    public String getWidgetId() {
        return null;
    }

    @Override
    public boolean hasWarnings() {
        for (IValidationMessage message : this.getState().getMessages()) {
            if (message.getSeverity() != 0 && message.getSeverity() != 1) continue;
            return true;
        }
        for (IStateNode child : this.getChildren()) {
            if (child.getState().getSeverity() == 2 || !child.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    public void setName(String pName) {
        this.name = pName;
    }
}

