/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.IStateNodeFactory;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;

public class GenericStateNodeFactory
implements IStateNodeFactory,
IElementConfigurable,
IContextSupport {
    private IElement element;
    private Object context;
    private Class nodeClass;
    private ObjectCreationException nodeClassException;
    private boolean delegateToTarget = true;

    public void configure(IElement element) throws ConfigurationException {
        this.element = element;
        this.setDelegateToTarget(ElementTools.getBool((IElement)element, (String)"delegateToTarget", (boolean)this.isDelegateToTarget()));
    }

    protected IStateNode createNode(Class[] parameterTypes, Object[] parameters) throws ObjectCreationException {
        Class nodeClass = this.getNodeClass();
        if (this.getNodeClassException() != null) {
            throw this.getNodeClassException();
        }
        if (nodeClass == null) {
            return null;
        }
        return (IStateNode)ObjectTools.createObject((Class)nodeClass, IStateNode.class, (Class[])parameterTypes, (Object[])parameters);
    }

    @Override
    public IStateNode createNode(IValidationState state) throws ObjectCreationException {
        if (state == null) {
            return null;
        }
        IStateNodeFactory factory = this.lookupDelegateFactory(state);
        if (factory != null) {
            return factory.createNode(state);
        }
        return this.createNode(new Class[]{IValidationState.class}, new Object[]{state});
    }

    @Override
    public IStateNode createNode(IValidationState state, String name) throws ObjectCreationException {
        if (state == null) {
            return null;
        }
        IStateNodeFactory factory = this.lookupDelegateFactory(state);
        if (factory != null) {
            return factory.createNode(state);
        }
        return this.createNode(new Class[]{String.class, IValidationState.class}, new Object[]{name, state});
    }

    public ClassLoader getClassLoader() {
        return this.context instanceof IClassLoaderSupport ? ((IClassLoaderSupport)this.context).getClassLoader() : this.getClass().getClassLoader();
    }

    public Object getContext() {
        return this.context;
    }

    public IElement getElement() {
        return this.element;
    }

    public Class getNodeClass() {
        if (this.nodeClass == null) {
            try {
                this.nodeClass = ElementTools.createClass((IElement)this.getElement(), (String)"nodeclass", Object.class, (Object)this.getContext());
            }
            catch (ObjectCreationException e) {
                this.nodeClassException = e;
            }
        }
        return this.nodeClass;
    }

    public ObjectCreationException getNodeClassException() {
        return this.nodeClassException;
    }

    public boolean isDelegateToTarget() {
        return this.delegateToTarget;
    }

    protected IStateNodeFactory lookupDelegateFactory(IValidationState state) {
        if (this.isDelegateToTarget() && state.getValidationTarget() != null) {
            Object validationTarget = state.getValidationTarget().getImpl();
            IStateNodeFactory factory = (IStateNodeFactory)AdapterTools.getAdapter((Object)validationTarget, IStateNodeFactory.class, null);
            return factory;
        }
        return null;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setDelegateToTarget(boolean delegateToTarget) {
        this.delegateToTarget = delegateToTarget;
    }

    public void setNodeClass(Class pageClass) {
        this.nodeClass = pageClass;
    }
}

