/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.StateNodeVisitorDeep;
import java.util.ArrayList;
import java.util.List;

public class MessageCollector
extends StateNodeVisitorDeep {
    private List<IValidationMessage> messages = new ArrayList<IValidationMessage>();
    private int minStateSeverity = 0;
    private int maxStateSeverity = 2;
    private int minMessageSeverity = 0;
    private int maxMessageSeverity = 2;
    private boolean collectDeep = true;

    @Override
    protected void basicVisit(IStateNode stateNode) {
        this.getMessages().addAll(this.getMessages(stateNode.getState()));
    }

    @Override
    protected boolean basicVisitChildAccept(IStateNode childNode, IStateNode parentNode) {
        if (!this.isCollectDeep()) {
            return false;
        }
        int severity = childNode.getState().getSeverity();
        if (severity < this.getMinStateSeverity() || severity > this.getMaxStateSeverity()) {
            return false;
        }
        return super.basicVisitChildAccept(childNode, parentNode);
    }

    public int getMaxMessageSeverity() {
        return this.maxMessageSeverity;
    }

    public int getMaxStateSeverity() {
        return this.maxStateSeverity;
    }

    public List<IValidationMessage> getMessages() {
        return this.messages;
    }

    protected List<IValidationMessage> getMessages(IValidationState state) {
        ArrayList<IValidationMessage> result = new ArrayList<IValidationMessage>();
        List messages = state.getMessages();
        for (IValidationMessage message : messages) {
            int severity = message.getSeverity();
            if (severity < this.getMinMessageSeverity() || severity > this.getMaxMessageSeverity()) continue;
            result.add(message);
        }
        return result;
    }

    public int getMinMessageSeverity() {
        return this.minMessageSeverity;
    }

    public int getMinStateSeverity() {
        return this.minStateSeverity;
    }

    public boolean isCollectDeep() {
        return this.collectDeep;
    }

    public void setCollectDeep(boolean collectDeep) {
        this.collectDeep = collectDeep;
    }

    public void setMaxMessageSeverity(int maxMessageSeverity) {
        this.maxMessageSeverity = maxMessageSeverity;
    }

    public void setMaxStateSeverity(int maxStateSeverity) {
        this.maxStateSeverity = maxStateSeverity;
    }

    public void setMinMessageSeverity(int minMessageSeverity) {
        this.minMessageSeverity = minMessageSeverity;
    }

    public void setMinStateSeverity(int minStateSeverity) {
        this.minStateSeverity = minStateSeverity;
    }
}

