/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSQualificationCertificate;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.CommonStateNode;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.SNCRL;
import de.intarsys.security.validation.node.SNCertificatePath;
import de.intarsys.security.validation.node.SNDefault;
import de.intarsys.security.validation.node.SNOCSP;
import de.intarsys.security.validation.node.SNQualificationCertificate;
import de.intarsys.security.validation.node.SNSignature;
import de.intarsys.security.validation.node.StateNodeFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;

public abstract class SNCertificate
extends CommonStateNode {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected SNCertificate(IValidationState state) {
        super(state);
    }

    protected SNCertificate(String name, IValidationState state) {
        super(name, state);
    }

    @Override
    protected String basicGetIconName() {
        return "certificate";
    }

    public SNCertificatePath getCertificatePathStateNode() {
        if (this.getState().getCertificatePathState() != null) {
            return new SNCertificatePath(Msg.getString("SNCertificate.LabelPath", new Object[0]), (IValidationState)this.getState().getCertificatePathState());
        }
        return null;
    }

    @Override
    public List<IStateNode> getChildren() {
        SNQualificationCertificate snQc;
        SNSignature snSignature;
        SNOCSP snOcsp;
        SNCRL snCrl;
        ArrayList<IStateNode> children = new ArrayList<IStateNode>();
        SNCertificatePath snCertPath = this.getCertificatePathStateNode();
        if (snCertPath != null) {
            children.add(snCertPath);
        }
        if ((snCrl = this.getCRLStateNode()) != null) {
            children.add(snCrl);
        }
        if ((snOcsp = this.getOCSPStateNode()) != null) {
            children.add(snOcsp);
        }
        if ((snSignature = this.getSignatureStateNode()) != null) {
            children.add(snSignature);
        }
        if ((snQc = this.getQCStateNode()) != null) {
            children.add(snQc);
        }
        return children;
    }

    public SNCRL getCRLStateNode() {
        if (this.getState().getCRLState() != null) {
            return new SNCRL(Msg.getString("SNCertificate.LabelCRL", new Object[0]), (IValidationState)this.getState().getCRLState());
        }
        return null;
    }

    public SNOCSP getOCSPStateNode() {
        if (this.getState().getOCSPState() != null) {
            return new SNOCSP(Msg.getString("SNCertificate.LabelOCSP", new Object[0]), (IValidationState)this.getState().getOCSPState());
        }
        return null;
    }

    public SNQualificationCertificate getQCStateNode() {
        if (this.getState().getQcState() != null) {
            return new SNQualificationCertificate((IValidationState)this.getState().getQcState());
        }
        return null;
    }

    public SNSignature getSignatureStateNode() {
        if (this.getState().getSignatureState() != null) {
            return new SNSignature(Msg.getString("SNCertificate.LabelSignature", new Object[0]), (IValidationState)this.getState().getSignatureState());
        }
        return null;
    }

    public IVSCertificate getState() {
        return (IVSCertificate)super.getState();
    }

    public IStateNode getValidityPeriodStateNode() {
        try {
            return StateNodeFactory.get().createNode(this.getState().getValidityPeriodState());
        }
        catch (ObjectCreationException e) {
            return new SNDefault(this.getState().getValidityPeriodState());
        }
    }

    protected boolean isQualified() {
        IVSQualificationCertificate qcState = this.getState().getQcState();
        if (qcState == null) {
            return false;
        }
        return qcState.isValid();
    }
}

