/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVTCertificate;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.CommonStateNode;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.SNKeyCertificate;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SNCertificatePath
extends CommonStateNode {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public SNCertificatePath(IValidationState state) {
        super(state);
    }

    public SNCertificatePath(String name, IValidationState state) {
        super(name, state);
    }

    @Override
    protected String basicGetIconName() {
        return "certpath";
    }

    public List<IStateNode> getCertificateStateNodes() {
        return this.getState().getCertificateStates().stream().map(i -> {
            IVTCertificate target = (IVTCertificate)i.getValidationTarget();
            if (target == null) {
                return new SNKeyCertificate((IValidationState)i);
            }
            String label = CertificateTools.getSubjectLabel((IX509Certificate)((IX509Certificate)target.getImpl()));
            return new SNKeyCertificate(label, (IValidationState)i);
        }).collect(Collectors.toList());
    }

    @Override
    public List<IStateNode> getChildren() {
        ArrayList<IStateNode> children = new ArrayList<IStateNode>();
        children.addAll(this.getCertificateStateNodes());
        return children;
    }

    @Override
    protected String getDefaultName() {
        return Msg.getString("SNCertificatePath.DefaultLabel", new Object[0]);
    }

    public IVSCertificatePath getState() {
        return (IVSCertificatePath)super.getState();
    }
}

