/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IVSRevocationRequest;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.CommonStateNode;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.SNCertificate;
import de.intarsys.security.validation.node.SNKeyCertificate;
import de.intarsys.security.validation.node.SNSignature;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.List;

public abstract class SNRevocationRequest
extends CommonStateNode {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private SNCertificate certificateStateNode;
    private SNSignature signatureStateNode;

    protected SNRevocationRequest(IValidationState state) {
        super(state);
    }

    protected SNRevocationRequest(String name, IValidationState state) {
        super(name, state);
    }

    public SNCertificate getCertificateStateNode() {
        if (this.certificateStateNode == null && this.getState().getCertificateState() != null) {
            this.certificateStateNode = new SNKeyCertificate(Msg.getString("SNRevocationRequest.LabelSignerCertificate", new Object[0]), (IValidationState)this.getState().getCertificateState());
        }
        return this.certificateStateNode;
    }

    @Override
    public List<IStateNode> getChildren() {
        SNCertificate snCertificate;
        ArrayList<IStateNode> children = new ArrayList<IStateNode>();
        SNSignature snSignature = this.getSignatureStateNode();
        if (snSignature != null) {
            children.add(snSignature);
        }
        if ((snCertificate = this.getCertificateStateNode()) != null) {
            children.add(snCertificate);
        }
        children.addAll(this.getAspectNodes());
        return children;
    }

    public SNSignature getSignatureStateNode() {
        if (this.signatureStateNode == null && this.getState().getSignatureState() != null) {
            this.signatureStateNode = new SNSignature(Msg.getString("SNRevocationRequest.LabelSignature", new Object[0]), (IValidationState)this.getState().getSignatureState());
        }
        return this.signatureStateNode;
    }

    public IVSRevocationRequest getState() {
        return (IVSRevocationRequest)super.getState();
    }
}

