/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.CommonStateNode;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.SNDigest;
import de.intarsys.security.validation.node.SNMathematicalSignature;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SNSignature
extends CommonStateNode {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private List<SNDigest> digestStateNodes;
    private SNMathematicalSignature signatureStateNode;

    public SNSignature(IValidationState state) {
        super(state);
    }

    public SNSignature(String name, IValidationState state) {
        super(name, state);
    }

    @Override
    protected String basicGetIconName() {
        return "quill";
    }

    @Override
    public List<IStateNode> getChildren() {
        ArrayList<IStateNode> children = new ArrayList<IStateNode>();
        children.addAll(this.getDigestStateNodes());
        if (this.getSignatureStateNode() != null) {
            children.add(this.getSignatureStateNode());
        }
        return children;
    }

    @Override
    protected String getDefaultName() {
        return Msg.getString("SNSignature.DefaultLabel", new Object[0]);
    }

    public List<SNDigest> getDigestStateNodes() {
        if (this.digestStateNodes == null) {
            String nodeName = Msg.getString("SNSignature.LabelDigest", new Object[0]);
            this.digestStateNodes = this.getState().getDigestStates().stream().map(i -> new SNDigest(nodeName, (IValidationState)i)).collect(Collectors.toList());
        }
        return this.digestStateNodes;
    }

    @Override
    protected String getPrimaryInvalidMessage() {
        String message = this.inheritChildMessage();
        if (message == null) {
            message = super.getPrimaryInvalidMessage();
        }
        return message;
    }

    @Override
    protected String getPrimaryUnknownMessage() {
        String message = this.inheritChildMessage();
        if (message == null) {
            message = super.getPrimaryUnknownMessage();
        }
        return message;
    }

    public SNMathematicalSignature getSignatureStateNode() {
        if (this.signatureStateNode == null && this.getState().getSignatureState() != null) {
            this.signatureStateNode = new SNMathematicalSignature(Msg.getString("SNSignature.LabelSignature", new Object[0]), this.getState().getSignatureState());
        }
        return this.signatureStateNode;
    }

    public IVSSignature getState() {
        return (IVSSignature)super.getState();
    }

    protected String inheritChildMessage() {
        StringBuilder sb = new StringBuilder();
        for (SNDigest child : this.getDigestStateNodes()) {
            if (!child.getState().isUnknown() && !child.getState().isInvalid()) continue;
            sb.append(child.getPrimaryMessage());
            break;
        }
        if (this.getSignatureStateNode().getState().isUnknown() || this.getSignatureStateNode().getState().isInvalid()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.getSignatureStateNode().getPrimaryMessage());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }
}

