/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.SNAttributeCertificate;
import de.intarsys.security.validation.node.SNCertificate;
import de.intarsys.security.validation.node.SNKeyCertificate;
import de.intarsys.security.validation.node.SNQualificationSignature;
import de.intarsys.security.validation.node.SNSignature;
import de.intarsys.security.validation.node.SNSignatureContainerEntry;
import de.intarsys.security.validation.node.SNTimestamp;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SNSignatureEntry
extends SNSignatureContainerEntry {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private List<SNTimestamp> timestampStateNodes;
    private SNSignature signatureStateNode;
    private SNCertificate certificateStateNode;
    private List<SNCertificate> attributeCertificateStateNodes;
    private SNQualificationSignature qualificationStateNode;

    public SNSignatureEntry(IValidationState state) {
        super(state);
    }

    public SNSignatureEntry(String name, IValidationState state) {
        super(name, state);
    }

    @Override
    protected String basicGetIconName() {
        return "quill";
    }

    protected String basicGetLabel(String levelId, String type) {
        if ("simple/advanced".equals(levelId)) {
            if ("personal".equals(type)) {
                return Msg.getString("SNSignatureEntry.LabelSignature", new Object[0]);
            }
            if ("seal".equals(type)) {
                return Msg.getString("SNSignatureEntry.LabelSeal", new Object[0]);
            }
        } else if ("qualified".equals(levelId)) {
            if ("personal".equals(type)) {
                return Msg.getString("SNSignatureEntry.LabelQualifiedSignature", new Object[0]);
            }
            if ("seal".equals(type)) {
                return Msg.getString("SNSignatureEntry.LabelQualifiedSeal", new Object[0]);
            }
        }
        return Msg.getString("SNSignatureEntry.DefaultLabel", new Object[0]);
    }

    public List<SNCertificate> getAttributeCertificateStateNodes() {
        if (this.attributeCertificateStateNodes == null && this.getState().getAttributeCertificateStates() != null) {
            String label = Msg.getString("SNSignatureEntry.LabelAttributeCertificate", new Object[0]);
            this.attributeCertificateStateNodes = this.getState().getAttributeCertificateStates().stream().map(i -> new SNAttributeCertificate(label, (IValidationState)i)).collect(Collectors.toList());
        }
        return this.attributeCertificateStateNodes;
    }

    public SNCertificate getCertificateStateNode() {
        if (this.certificateStateNode == null && this.getState().getCertificateState() != null) {
            this.certificateStateNode = new SNKeyCertificate(Msg.getString("SNSignatureEntry.LabelSignerCertificate", new Object[0]), (IValidationState)this.getState().getCertificateState());
        }
        return this.certificateStateNode;
    }

    @Override
    public List<IStateNode> getChildren() {
        ArrayList<IStateNode> children = new ArrayList<IStateNode>();
        if (this.getSignatureStateNode() != null) {
            children.add(this.getSignatureStateNode());
        }
        if (this.getCertificateStateNode() != null) {
            children.add(this.getCertificateStateNode());
        }
        if (this.getTimestampStateNodes() != null) {
            children.addAll(this.getTimestampStateNodes());
        }
        if (this.getAttributeCertificateStateNodes() != null) {
            children.addAll(this.getAttributeCertificateStateNodes());
        }
        if (this.getQualificationStateNode() != null) {
            children.add(this.getQualificationStateNode());
        }
        children.addAll(this.getAspectNodes());
        return children;
    }

    @Override
    protected String getDefaultName() {
        String levelId = this.getState().getSignatureLevel();
        String type = this.getState().getSignatureType();
        return this.basicGetLabel(levelId, type);
    }

    @Override
    protected String getPrimaryInvalidMessage() {
        return Msg.getString("SNSignatureEntry.PrimaryMessageInvalid", new Object[]{this.getName()});
    }

    @Override
    protected String getPrimaryUndefinedMessage() {
        return Msg.getString("SNSignatureEntry.PrimaryMessageUndefined", new Object[]{this.getName()});
    }

    @Override
    protected String getPrimaryUnknownMessage() {
        return Msg.getString("SNSignatureEntry.PrimaryMessageUnknown", new Object[]{this.getName()});
    }

    @Override
    protected String getPrimaryValidMessage() {
        if (this.isQualified()) {
            return Msg.getString("SNSignatureEntry.PrimaryMessageValidQualified", new Object[]{this.getName()});
        }
        return Msg.getString("SNSignatureEntry.PrimaryMessageValid", new Object[]{this.getName()});
    }

    public SNQualificationSignature getQualificationStateNode() {
        if (this.qualificationStateNode == null && this.getState().getQualificationState() != null) {
            this.qualificationStateNode = new SNQualificationSignature(Msg.getString("SNSignatureEntry.LabelQualified", new Object[0]), (IValidationState)this.getState().getQualificationState());
        }
        return this.qualificationStateNode;
    }

    public SNSignature getSignatureStateNode() {
        if (this.signatureStateNode == null && this.getState().getSignatureState() != null) {
            this.signatureStateNode = new SNSignature(Msg.getString("SNSignatureEntry.LabelSignature", new Object[0]), (IValidationState)this.getState().getSignatureState());
        }
        return this.signatureStateNode;
    }

    public IVSSignatureEntry getState() {
        return (IVSSignatureEntry)super.getState();
    }

    public List<SNTimestamp> getTimestampStateNodes() {
        if (this.timestampStateNodes == null && this.getState().getTimestampStates() != null) {
            String label = Msg.getString("SNSignatureEntry.LabelTimestamp", new Object[0]);
            this.timestampStateNodes = this.getState().getTimestampStates().stream().map(i -> new SNTimestamp(label, (IValidationState)i)).collect(Collectors.toList());
        }
        return this.timestampStateNodes;
    }

    protected boolean isQualified() {
        IVSQualification qcState = this.getState().getQualificationState();
        if (qcState == null) {
            return false;
        }
        return qcState.isValid();
    }
}

