/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.node;

import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.CommonStateNode;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.PACKAGE;
import de.intarsys.security.validation.node.SNDigest;
import de.intarsys.security.validation.node.SNQualification;
import de.intarsys.security.validation.node.SNQualificationTimestamp;
import de.intarsys.security.validation.node.SNSignatureContainer;
import de.intarsys.security.validation.node.StateNodeTools;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.List;

public class SNTimestamp
extends CommonStateNode {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private SNSignatureContainer signatureStateNode;
    private SNDigest digestStateNode;
    private SNQualification qualificationStateNode;

    public SNTimestamp(IValidationState state) {
        super(state);
    }

    public SNTimestamp(String name, IValidationState state) {
        super(name, state);
    }

    @Override
    protected String basicGetIconName() {
        return "clock";
    }

    @Override
    public List<IStateNode> getChildren() {
        ArrayList<IStateNode> children = new ArrayList<IStateNode>();
        if (this.getDigestStateNode() != null) {
            children.add(this.getDigestStateNode());
        }
        if (this.getSignatureStateNode() != null) {
            children.addAll(this.getSignatureStateNode().getChildren());
        }
        if (this.getQualificationStateNode() != null) {
            children.add(this.getQualificationStateNode());
        }
        return children;
    }

    @Override
    protected String getDefaultName() {
        if (this.isQualified()) {
            return Msg.getString("SNTimestamp.QualifiedTimestampLabel", new Object[0]);
        }
        return Msg.getString("SNTimestamp.DefaultLabel", new Object[0]);
    }

    public SNDigest getDigestStateNode() {
        if (this.digestStateNode == null && this.getState().getDigestState() != null) {
            this.digestStateNode = new SNDigest(Msg.getString("SNTimestamp.LabelDigest", new Object[0]), (IValidationState)this.getState().getDigestState());
        }
        return this.digestStateNode;
    }

    @Override
    protected String getPrimaryInvalidMessage() {
        return Msg.getString("SNTimestamp.PrimaryMessageInvalid", new Object[]{this.getName()});
    }

    @Override
    protected String getPrimaryUndefinedMessage() {
        return Msg.getString("SNTimestamp.PrimaryMessageUndefined", new Object[]{this.getName()});
    }

    @Override
    protected String getPrimaryUnknownMessage() {
        return Msg.getString("SNTimestamp.PrimaryMessageUnknown", new Object[]{this.getName()});
    }

    @Override
    protected String getPrimaryValidMessage() {
        if (this.isQualified()) {
            return Msg.getString("SNTimestamp.PrimaryMessageValidQualified", new Object[]{this.getName()});
        }
        return Msg.getString("SNTimestamp.PrimaryMessageValid", new Object[]{this.getName()});
    }

    public SNQualification getQualificationStateNode() {
        if (this.qualificationStateNode == null && this.getState().getQualificationState() != null) {
            this.qualificationStateNode = new SNQualificationTimestamp(Msg.getString("SNTimestamp.LabelQualifiedTimestamp", new Object[0]), (IValidationState)this.getState().getQualificationState());
        }
        return this.qualificationStateNode;
    }

    public SNSignatureContainer getSignatureStateNode() {
        if (this.signatureStateNode == null && this.getState().getSignatureState() != null) {
            this.signatureStateNode = (SNSignatureContainer)StateNodeTools.createNode((IValidationState)this.getState().getSignatureState(), Msg.getString("SNTimestamp.LabelSignatures", new Object[0]));
        }
        return this.signatureStateNode;
    }

    public IVSTimestamp getState() {
        return (IVSTimestamp)super.getState();
    }

    protected boolean isQualified() {
        IVSQualification qcState = this.getState().getQualificationState();
        if (qcState == null) {
            return false;
        }
        return qcState.isValid();
    }
}

