/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.validation.serialization.CommonDtoSerializer;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;

public class AlgorithmSpecSerializer
extends CommonDtoSerializer<AlgorithmSpec> {
    public AlgorithmSpecSerializer(ValidationNodeModule module) {
        super(module, AlgorithmSpec.class);
    }

    @Override
    protected void serializeMembers(AlgorithmSpec value, JsonGenerator jgen) throws IOException {
        super.serializeMembers(value, jgen);
        jgen.writeStringField("oid", value.getAlgorithm().getOid());
        jgen.writeStringField("name", value.getAlgorithm().getCanonicalName());
        if (value.getParameterSpec() != null) {
            try {
                jgen.writeObjectField("parameters", (Object)value.getParameterSpec());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

