/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.CommonStateNode;
import de.intarsys.security.validation.serialization.CommonValidationSerializer;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;

public abstract class CommonStateNodeSerializer<T extends CommonStateNode>
extends CommonValidationSerializer<T> {
    public CommonStateNodeSerializer(ValidationNodeModule module, Class<T> t) {
        super(module, t);
    }

    protected Object createTargetObject(T value, Object impl) {
        return ((CommonStateNode)value).getState().getValidationTarget().getImpl().getClass().getName();
    }

    protected boolean isSerializeTarget() {
        return false;
    }

    public final void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        this.serializeMembers(value, jgen);
        jgen.writeEndObject();
    }

    protected void serializeMembers(T value, JsonGenerator jgen) throws IOException {
        IValidationState state = ((CommonStateNode)value).getState();
        jgen.writeStringField("type", value.getClass().getName());
        jgen.writeObjectField("validationDate", (Object)this.getModule().formatDateTime(((CommonStateNode)value).getState().getValidationTime()));
        jgen.writeStringField("state", IValidationState.getStateLabel((int)state.getState()));
        jgen.writeStringField("severity", IValidationState.getSeverityLabel((int)state.getSeverity()));
        jgen.writeStringField("icon", ((CommonStateNode)value).getIconName());
        jgen.writeStringField("label", ((CommonStateNode)value).getLabel());
        jgen.writeStringField("description", ((CommonStateNode)value).getDescription());
        jgen.writeStringField("messagePrimary", ((CommonStateNode)value).getPrimaryMessage());
        jgen.writeBooleanField("hasWarnings", ((CommonStateNode)value).hasWarnings());
        if (state.getMessages().size() > 0) {
            jgen.writeObjectField("messages", (Object)state.getMessages());
        }
        if (this.isSerializeTarget() && state.getValidationTarget() != null) {
            Object impl = ((CommonStateNode)value).getState().getValidationTarget().getImpl();
            jgen.writeObjectField("target", this.createTargetObject(value, impl));
        }
        if (state.getAspects().size() > 0) {
            jgen.writeObjectField("aspectStates", ((CommonStateNode)value).getAspectNodes());
        }
    }
}

