/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.validation.serialization.DtoAttribute;
import de.intarsys.security.validation.serialization.DtoDigest;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DtoCertificate {
    private final IX509Certificate certificate;

    public static DtoCertificate create(IX509Certificate x509Certificate) {
        return x509Certificate == null ? null : new DtoCertificate(x509Certificate);
    }

    protected DtoCertificate(IX509Certificate certificate) {
        this.certificate = certificate;
    }

    public List<DtoAttribute> getAttributes() {
        return Collections.EMPTY_LIST;
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    public String getEncoded() {
        try {
            return Base64.getEncoder().encodeToString(this.certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return "<error>";
        }
    }

    public List<DtoDigest> getExtensions() {
        return Collections.EMPTY_LIST;
    }

    public String getFingerprint() {
        try {
            IDigester digester = DigestTools.createDigester((String)"SHA-256");
            IDigest digest = digester.digest(this.certificate.getEncoded());
            return digest.toString();
        }
        catch (GeneralSecurityException e) {
            return "unavailable";
        }
    }

    public String getIssuer() {
        return this.certificate.getIssuerX500Principal().toString();
    }

    public String getIssuerLabel() {
        return CertificateTools.getIssuerLabel((IX509Certificate)this.certificate);
    }

    public int getKeyBitSize() {
        if (this.certificate instanceof IX509PublicKeyCertificate) {
            IX509PublicKeyCertificate signerKeyCertificate = (IX509PublicKeyCertificate)this.certificate;
            return signerKeyCertificate.getKeyBitSize();
        }
        return 0;
    }

    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    public String getSerialNumber() {
        return this.certificate.getSerialNumber().toString();
    }

    public String getSignatureAlgorithmLabel() {
        return this.certificate.getSigAlgName();
    }

    public String getSubject() {
        return this.certificate.getSubjectX500Principal().toString();
    }

    public String getSubjectLabel() {
        return CertificateTools.getSubjectLabel((IX509Certificate)this.certificate);
    }
}

