/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.security.validation.serialization.CommonDtoSerializer;
import de.intarsys.security.validation.serialization.DtoCertificate;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;

public class DtoCertificateSerializer
extends CommonDtoSerializer<DtoCertificate> {
    public DtoCertificateSerializer(ValidationNodeModule module) {
        super(module, DtoCertificate.class);
    }

    @Override
    protected boolean isSerializeType() {
        return true;
    }

    @Override
    protected void serializeMembers(DtoCertificate value, JsonGenerator jgen) throws IOException {
        super.serializeMembers(value, jgen);
        jgen.writeStringField("serialNumber", value.getSerialNumber());
        jgen.writeStringField("subject", value.getSubject());
        jgen.writeStringField("subjectLabel", value.getSubjectLabel());
        jgen.writeStringField("issuer", value.getIssuer());
        jgen.writeStringField("issuerLabel", value.getIssuerLabel());
        jgen.writeStringField("notAfter", this.getModule().formatDateTime(value.getNotAfter()));
        jgen.writeStringField("notBefore", this.getModule().formatDateTime(value.getNotBefore()));
        jgen.writeNumberField("keyBitSize", value.getKeyBitSize());
        if (this.getModule().isAddEncodedValues()) {
            jgen.writeStringField("encoded", value.getEncoded());
        }
        jgen.writeObjectField("attributes", value.getAttributes());
        jgen.writeObjectField("extensions", value.getExtensions());
        jgen.writeObjectField("fingerprint", (Object)value.getFingerprint());
    }
}

