/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.security.validation.IQCInfo;
import de.intarsys.security.validation.serialization.CommonDtoSerializer;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;
import java.util.Base64;

public class QCInfoSerializer
extends CommonDtoSerializer<IQCInfo> {
    public QCInfoSerializer(ValidationNodeModule module) {
        super(module, IQCInfo.class);
    }

    @Override
    protected void serializeMembers(IQCInfo value, JsonGenerator jgen) throws IOException {
        super.serializeMembers(value, jgen);
        jgen.writeStringField("limitCurrency", value.getLimitCurrency());
        jgen.writeObjectField("generationDate", (Object)this.getModule().formatDateTime(value.getGenerationDate()));
        byte[] iccsn = value.getICCSN();
        if (iccsn != null) {
            jgen.writeStringField("iccsn", Base64.getEncoder().encodeToString(iccsn));
        }
        jgen.writeNumberField("limitValue", value.getLimitValue());
        jgen.writeNumberField("retentionPeriod", value.getRetentionPeriod());
    }
}

