/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.security.validation.node.SNCertificate;
import de.intarsys.security.validation.serialization.CommonStateNodeSerializer;
import de.intarsys.security.validation.serialization.DtoCertificate;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;

public abstract class SNCertificateSerializer<T extends SNCertificate>
extends CommonStateNodeSerializer<T> {
    public SNCertificateSerializer(ValidationNodeModule module, Class t) {
        super(module, t);
    }

    @Override
    protected Object createTargetObject(T value, Object impl) {
        return DtoCertificate.create(((SNCertificate)value).getState().getX509Certificate());
    }

    @Override
    protected boolean isSerializeTarget() {
        return true;
    }

    @Override
    protected void serializeMembers(T value, JsonGenerator jgen) throws IOException {
        super.serializeMembers(value, jgen);
        jgen.writeObjectField("certificatePathState", (Object)((SNCertificate)value).getCertificatePathStateNode());
        jgen.writeObjectField("crlState", (Object)((SNCertificate)value).getCRLStateNode());
        jgen.writeObjectField("ocspState", (Object)((SNCertificate)value).getOCSPStateNode());
        jgen.writeObjectField("qcState", (Object)((SNCertificate)value).getQCStateNode());
        jgen.writeObjectField("signatureState", (Object)((SNCertificate)value).getSignatureStateNode());
        jgen.writeObjectField("validityPeriodState", (Object)((SNCertificate)value).getValidityPeriodStateNode());
        jgen.writeObjectField("referenceDate", (Object)this.getModule().formatDateTime(((SNCertificate)value).getState().getReferenceDate()));
        jgen.writeObjectField("trustBase", (Object)((SNCertificate)value).getState().getTrustBase());
    }
}

