/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.security.validation.node.SNDigest;
import de.intarsys.security.validation.serialization.CommonStateNodeSerializer;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;
import java.util.Base64;

public class SNDigestSerializer
extends CommonStateNodeSerializer<SNDigest> {
    public SNDigestSerializer(ValidationNodeModule module) {
        super(module, SNDigest.class);
    }

    @Override
    protected void serializeMembers(SNDigest value, JsonGenerator jgen) throws IOException {
        super.serializeMembers(value, jgen);
        jgen.writeObjectField("algorithm", (Object)value.getState().getAlgorithmSpec());
        byte[] calculatedDigest = value.getState().getCalculatedDigest();
        if (this.getModule().isAddEncodedValues() && calculatedDigest != null) {
            jgen.writeStringField("calculatedDigest", Base64.getEncoder().encodeToString(calculatedDigest));
        }
        byte[] referenceDigest = value.getState().getReferenceDigest();
        if (this.getModule().isAddEncodedValues() && referenceDigest != null) {
            jgen.writeStringField("referenceDigest", Base64.getEncoder().encodeToString(referenceDigest));
        }
    }
}

