/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.security.validation.node.SNSignatureEntry;
import de.intarsys.security.validation.serialization.SNSignatureContainerEntrySerializer;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import java.io.IOException;

public class SNSignatureEntrySerializer
extends SNSignatureContainerEntrySerializer<SNSignatureEntry> {
    public SNSignatureEntrySerializer(ValidationNodeModule module) {
        super(module, SNSignatureEntry.class);
    }

    @Override
    protected void serializeMembers(SNSignatureEntry value, JsonGenerator jgen) throws IOException {
        super.serializeMembers(value, jgen);
        jgen.writeStringField("creationDateSource", value.getState().getCreationDateSource());
        jgen.writeObjectField("referenceDate", (Object)this.getModule().formatDateTime(value.getState().getReferenceDate()));
        jgen.writeStringField("signatureLevel", value.getState().getSignatureLevel());
        jgen.writeObjectField("signatureState", (Object)value.getSignatureStateNode());
        jgen.writeObjectField("qualificationState", (Object)value.getQualificationStateNode());
        jgen.writeObjectField("certificateState", (Object)value.getCertificateStateNode());
        jgen.writeObjectField("timestampStates", value.getTimestampStateNodes());
    }
}

