/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.models.OrganizationDetails;
import java.io.IOException;

public final class CertificateIssuerUpdateParameters
implements JsonSerializable<CertificateIssuerUpdateParameters> {
    private String provider;
    private IssuerCredentials credentials;
    private OrganizationDetails organizationDetails;
    private IssuerAttributes attributes;

    public String getProvider() {
        return this.provider;
    }

    public CertificateIssuerUpdateParameters setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public IssuerCredentials getCredentials() {
        return this.credentials;
    }

    public CertificateIssuerUpdateParameters setCredentials(IssuerCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public OrganizationDetails getOrganizationDetails() {
        return this.organizationDetails;
    }

    public CertificateIssuerUpdateParameters setOrganizationDetails(OrganizationDetails organizationDetails) {
        this.organizationDetails = organizationDetails;
        return this;
    }

    public IssuerAttributes getAttributes() {
        return this.attributes;
    }

    public CertificateIssuerUpdateParameters setAttributes(IssuerAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeJsonField("org_details", (JsonSerializable)this.organizationDetails);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        return jsonWriter.writeEndObject();
    }

    public static CertificateIssuerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateIssuerUpdateParameters)jsonReader.readObject(reader -> {
            CertificateIssuerUpdateParameters deserializedCertificateIssuerUpdateParameters = new CertificateIssuerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    deserializedCertificateIssuerUpdateParameters.provider = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedCertificateIssuerUpdateParameters.credentials = IssuerCredentials.fromJson(reader);
                    continue;
                }
                if ("org_details".equals(fieldName)) {
                    deserializedCertificateIssuerUpdateParameters.organizationDetails = OrganizationDetails.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificateIssuerUpdateParameters.attributes = IssuerAttributes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateIssuerUpdateParameters;
        });
    }
}

