/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatesUtils;
import com.azure.security.keyvault.certificates.implementation.models.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.implementation.models.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.models.OrganizationDetails;
import com.azure.security.keyvault.certificates.models.AdministratorContact;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificateIssuer
implements JsonSerializable<CertificateIssuer> {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateIssuer.class);
    private final IssuerBundle impl;
    private final String name;

    public CertificateIssuer(String name, String provider) {
        this.name = name;
        this.impl = new IssuerBundle().setProvider(provider);
    }

    public CertificateIssuer(String name) {
        this(name, null);
    }

    private CertificateIssuer(IssuerBundle impl) {
        this.impl = impl;
        this.name = CertificatesUtils.getIdMetadata(impl.getId(), -1, 3, -1, LOGGER).getName();
    }

    public String getId() {
        return this.impl.getId();
    }

    public String getProvider() {
        return this.impl.getProvider();
    }

    public String getName() {
        return this.name;
    }

    public String getAccountId() {
        return this.impl.getCredentials() == null ? null : this.impl.getCredentials().getAccountId();
    }

    public CertificateIssuer setAccountId(String accountId) {
        if (this.impl.getCredentials() == null) {
            this.impl.setCredentials(new IssuerCredentials());
        }
        this.impl.getCredentials().setAccountId(accountId);
        return this;
    }

    public String getPassword() {
        return this.impl.getCredentials() == null ? null : this.impl.getCredentials().getPassword();
    }

    public CertificateIssuer setPassword(String password) {
        if (this.impl.getCredentials() == null) {
            this.impl.setCredentials(new IssuerCredentials());
        }
        this.impl.getCredentials().setPassword(password);
        return this;
    }

    public String getOrganizationId() {
        return this.impl.getOrganizationDetails() == null ? null : this.impl.getOrganizationDetails().getId();
    }

    public CertificateIssuer setOrganizationId(String organizationId) {
        if (this.impl.getOrganizationDetails() == null) {
            this.impl.setOrganizationDetails(new OrganizationDetails());
        }
        this.impl.getOrganizationDetails().setId(organizationId);
        return this;
    }

    public List<AdministratorContact> getAdministratorContacts() {
        return this.impl.getOrganizationDetails() == null ? null : this.impl.getOrganizationDetails().getAdminDetails();
    }

    public CertificateIssuer setAdministratorContacts(List<AdministratorContact> administratorContacts) {
        if (this.impl.getOrganizationDetails() == null) {
            this.impl.setOrganizationDetails(new OrganizationDetails());
        }
        this.impl.getOrganizationDetails().setAdminDetails(administratorContacts);
        return this;
    }

    public Boolean isEnabled() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().isEnabled();
    }

    public CertificateIssuer setEnabled(Boolean enabled) {
        if (this.impl.getAttributes() == null) {
            this.impl.setAttributes(new IssuerAttributes());
        }
        this.impl.getAttributes().setEnabled(enabled);
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getCreated();
    }

    public OffsetDateTime getUpdatedOn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getUpdated();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.impl.toJson(jsonWriter);
    }

    public static CertificateIssuer fromJson(JsonReader jsonReader) throws IOException {
        return new CertificateIssuer(IssuerBundle.fromJson(jsonReader));
    }

    static {
        CertificateIssuerHelper.setAccessor(new CertificateIssuerHelper.CertificateIssuerAccessor(){

            @Override
            public CertificateIssuer createCertificateIssuer(IssuerBundle impl) {
                return new CertificateIssuer(impl);
            }

            @Override
            public IssuerBundle getImpl(CertificateIssuer certificateIssuer) {
                return certificateIssuer.impl;
            }
        });
    }
}

