/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.core;

import de.intarsys.remote.core.AbstractRemoteObject;
import de.intarsys.remote.core.IRemoteCall;
import de.intarsys.remote.core.IRemoteContext;
import de.intarsys.remote.core.RemoteCallInvocationTargetException;
import de.intarsys.remote.core.RemoteCallProtocolException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public abstract class AbstractRemoteCall
implements IRemoteCall {
    private final IArgs args = Args.create();
    private final IRemoteContext context;
    private final String name;
    private final AbstractRemoteObject remote;

    public AbstractRemoteCall(AbstractRemoteObject remote, String name) {
        this.remote = remote;
        this.context = remote.getContext();
        this.name = name;
    }

    public void addParameter(Object value) {
        this.args.add(value);
    }

    @Override
    public void addParameter(String name, Object value) {
        ArgTools.putPath((IArgs)this.args, (String)name, (Object)value);
    }

    @Override
    public void addParameters(IArgs args) {
        ArgTools.putAllDeep((IArgs)this.args, (IArgs)args);
    }

    protected abstract Object basicExecute() throws RemoteCallInvocationTargetException, RemoteCallProtocolException;

    @Override
    public Object execute() throws RemoteCallInvocationTargetException, RemoteCallProtocolException {
        this.getContext().executeBefore(this);
        try {
            Object object = this.basicExecute();
            return object;
        }
        finally {
            this.getContext().executeFinally(this);
        }
    }

    protected IArgs getArgs() {
        return this.args;
    }

    public IRemoteContext getContext() {
        return this.context;
    }

    protected Object getLogLabel() {
        return this.getRemote().getLogLabel();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object getParameter(String name) {
        return ArgTools.getObject((IArgs)this.args, (String)name, null);
    }

    @Override
    public IArgs getParameters() {
        return this.args;
    }

    public AbstractRemoteObject getRemote() {
        return this.remote;
    }
}

