/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.core;

import de.intarsys.remote.core.IRemoteCall;
import de.intarsys.remote.core.IRemoteContext;
import de.intarsys.remote.core.RemoteCallMarshallingException;
import de.intarsys.remote.core.RemoteCallUnmarshallingException;
import de.intarsys.tools.ipc.IIPCScope;
import de.intarsys.tools.ipc.IPCMarshaller;
import de.intarsys.tools.ipc.IPCScope;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRemoteContext
implements IRemoteContext {
    public static final String ARG_SESSIONID = "de_intarsys_remote_session_id";
    public static final String ARG_SESSIONLAZY = "de_intarsys_remote_session_lazy";
    private IIPCScope previousScope;
    private IIPCScope scope;
    private IPCMarshaller marshaller = new IPCMarshaller();
    private boolean createSession = false;
    private String sessionId;
    private boolean sessionLazy = false;
    private boolean multithreaded = false;
    private Lock executionLock = new ReentrantLock();

    @Override
    public void attach() {
        this.previousScope = IPCScope.lookup();
        IPCScope.set((IIPCScope)this.getScope());
    }

    @Override
    public void detach() {
        this.setScope(IPCScope.lookup());
        IPCScope.set((IIPCScope)this.previousScope);
    }

    @Override
    public void executeBefore(IRemoteCall remoteCall) {
        if (!this.isMultithreaded()) {
            this.executionLock.lock();
        }
        if (remoteCall.getParameter("_session") == null && this.getSessionId() != null) {
            remoteCall.addParameter("_session.id", this.getSessionId());
            if (this.isSessionLazy()) {
                remoteCall.addParameter("_session.lazy", true);
            }
        }
        this.attach();
    }

    @Override
    public void executeFinally(IRemoteCall remoteCall) {
        this.detach();
        if (!this.isMultithreaded()) {
            this.executionLock.unlock();
        }
    }

    public IIPCScope getScope() {
        return this.scope;
    }

    public String getSessionId() {
        if (this.sessionId == null && this.isCreateSession()) {
            this.sessionId = UUID.randomUUID().toString();
        }
        return this.sessionId;
    }

    public boolean isCreateSession() {
        return this.createSession;
    }

    public boolean isMultithreaded() {
        return this.multithreaded;
    }

    public boolean isSessionLazy() {
        return this.sessionLazy;
    }

    @Override
    public Object marshal(Object value) throws RemoteCallMarshallingException {
        try {
            Object object = this.marshaller.marshal(value);
            return object;
        }
        catch (IOException e) {
            throw new RemoteCallMarshallingException(e);
        }
        finally {
            this.setScope(IPCScope.lookup());
        }
    }

    @Deprecated
    public Object marshall(Object value) throws RemoteCallMarshallingException {
        return this.marshal(value);
    }

    public void setCreateSession(boolean createSession) {
        this.createSession = createSession;
        this.setSessionLazy(createSession);
    }

    public void setMultithreaded(boolean multithreaded) {
        this.multithreaded = multithreaded;
    }

    protected void setScope(IIPCScope scope) {
        this.scope = scope;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionLazy(boolean sessionLazy) {
        this.sessionLazy = sessionLazy;
    }

    @Override
    public Object unmarshal(Object value) throws RemoteCallUnmarshallingException {
        try {
            Object object = this.marshaller.unmarshal(value);
            return object;
        }
        catch (IOException e) {
            throw new RemoteCallUnmarshallingException(e);
        }
        finally {
            this.setScope(IPCScope.lookup());
        }
    }

    @Deprecated
    public Object unmarshall(Object value) throws RemoteCallUnmarshallingException {
        return this.unmarshal(value);
    }
}

