/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.core;

import de.intarsys.remote.core.IRemoteCall;
import de.intarsys.remote.core.IRemoteContext;
import de.intarsys.remote.core.IRemoteObject;
import de.intarsys.remote.core.RemoteCallInvocationTargetException;
import de.intarsys.remote.core.RemoteCallProtocolException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodExecutionException;
import java.util.Iterator;

public abstract class AbstractRemoteObject
implements IRemoteObject,
IPresentationSupport {
    private final IRemoteContext context;

    public AbstractRemoteObject(IRemoteContext context) {
        this.context = context;
    }

    @Override
    public abstract IRemoteCall createCall(String var1);

    @Override
    public IRemoteContext getContext() {
        return this.context;
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return this.toString();
    }

    public Object getLogLabel() {
        return this.toString();
    }

    public String getTip() {
        return this.getLabel();
    }

    public Object invoke(String name, IArgs args) throws MethodException {
        IRemoteCall call = this.createCall(name);
        int i = 0;
        try {
            Iterator it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = (IArgs.IBinding)it.next();
                if (binding.getName() != null) {
                    call.addParameter(binding.getName(), binding.getValue());
                } else {
                    call.addParameter("" + i, binding.getValue());
                }
                ++i;
            }
            return call.execute();
        }
        catch (RemoteCallInvocationTargetException e) {
            throw new MethodExecutionException(name, (Throwable)e);
        }
        catch (RemoteCallProtocolException e) {
            throw new MethodExecutionException(name, (Throwable)e);
        }
    }
}

