/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.core;

import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class RemoteTools {
    public static <R> List<R> toList(IArgs args, Function<Object, R> mapper) {
        ArrayList<R> result = new ArrayList<R>(args.size());
        ListTools.allocate(result, (int)args.size());
        Iterator it = args.bindings();
        int index = 0;
        while (it.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)it.next();
            Object entryValue = binding.getValue();
            R convertedValue = mapper.apply(entryValue);
            result.set(index, convertedValue);
            ++index;
        }
        return result;
    }

    public static <R> List<R> toList(List list, Function<Object, R> mapper) {
        ArrayList<R> result = new ArrayList<R>(list.size());
        ListTools.allocate(result, (int)list.size());
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object listValue = it.next();
            R convertedValue = mapper.apply(listValue);
            result.set(index, convertedValue);
            ++index;
        }
        return result;
    }

    public static <R> List<R> toList(Map map, Function<Object, R> mapper) {
        ArrayList<R> result = new ArrayList<R>(map.size());
        ListTools.allocate(result, (int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            int index = Integer.parseInt((String)entry.getKey());
            Object entryValue = entry.getValue();
            R convertedValue = mapper.apply(entryValue);
            result.set(index, convertedValue);
        }
        return result;
    }

    public static <R> List<R> toList(Object value, Function<Object, R> mapper) throws ObjectCreationException {
        if (value instanceof Map) {
            Map tmpValue = (Map)value;
            return RemoteTools.toList(tmpValue, mapper);
        }
        if (value instanceof IArgs) {
            IArgs tmpValue = (IArgs)value;
            return RemoteTools.toList(tmpValue, mapper);
        }
        if (value instanceof List) {
            List tmpValue = (List)value;
            return RemoteTools.toList(tmpValue, mapper);
        }
        if (value == null || value instanceof String && StringTools.isEmpty((String)((String)value))) {
            return Collections.EMPTY_LIST;
        }
        throw new ObjectCreationException("invalid data type");
    }

    private RemoteTools() {
    }
}

