/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.core;

import de.intarsys.remote.core.IRemoteContext;
import de.intarsys.remote.core.IRemoteContextFactory;
import de.intarsys.remote.core.RemoteException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.provider.Providers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StandardRemoteContextFactory
implements IRemoteContextFactory {
    private final List<IRemoteContextFactory> factories = new ArrayList<IRemoteContextFactory>();

    public StandardRemoteContextFactory() {
        this.init();
    }

    public IRemoteContext createContext(IArgs args) throws RemoteException {
        for (IRemoteContextFactory factory : this.factories) {
            Object context = factory.createContext(args);
            if (context == null) continue;
            return context;
        }
        throw new RemoteException("no context factory found");
    }

    private void init() {
        Iterator it = Providers.get().lookupProviders(IRemoteContextFactory.class);
        while (it.hasNext()) {
            this.registerFactory((IRemoteContextFactory)it.next());
        }
    }

    public void registerFactory(IRemoteContextFactory factory) {
        this.factories.add(factory);
    }
}

