/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.file;

import de.intarsys.jpa.common.AttachedPersistentObject;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Lob;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import java.util.List;

@Entity
@Table(name="t_attachment")
public class Attachment
extends AttachedPersistentObject {
    @Column(name="c_data_value")
    @Lob
    private byte[] dataValue;
    @Column(name="c_encoding")
    private String encoding;
    @Column(name="c_data_link")
    private String dataLink;
    @Column(name="c_path", nullable=false)
    private String path;
    @Column(name="c_mimetype")
    private String mimeType;
    @Column(name="c_extension")
    private String extension;

    public static List<Attachment> all(EntityManager em) {
        Query query = em.createQuery("SELECT x FROM Attachment x");
        List objects = query.getResultList();
        return objects;
    }

    public static int count(EntityManager em) {
        Query query = em.createQuery("select count(x) from Attachment x");
        return ((Number)query.getSingleResult()).intValue();
    }

    public static Attachment create() {
        Attachment object = new Attachment();
        return object;
    }

    public String getDataPath() {
        return this.dataLink;
    }

    public byte[] getDataValue() {
        return this.dataValue;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getPath() {
        return this.path;
    }

    public void setDataLink(String dataPath) {
        if (!this.willChange("dataLink", null, null)) {
            return;
        }
        this.dataLink = dataPath;
    }

    public void setDataValue(byte[] data) {
        if (!this.willChange("dataValue", null, null)) {
            return;
        }
        this.dataValue = data;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExtension(String extension) {
        if (!this.willChange("extension", null, null)) {
            return;
        }
        this.extension = extension;
    }

    public void setMimeType(String mimeType) {
        if (!this.willChange("mimeType", null, null)) {
            return;
        }
        this.mimeType = mimeType;
    }

    public void setPath(String path) {
        if (!this.willChange("path", null, null)) {
            return;
        }
        this.path = path;
    }
}

