/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.file;

import de.intarsys.model.common.file.DBNode;
import de.intarsys.model.common.file.IDBFile;
import de.intarsys.tools.string.StringTools;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

@Entity
@Table(name="t_dbfile")
@DiscriminatorValue(value="F")
@PrimaryKeyJoinColumn(name="fk_dbnode")
public class DBFile
extends DBNode
implements IDBFile {
    public static final String CHARSET_UTF_8 = "UTF-8";
    @Column(name="c_encoding")
    private String encoding;
    @Column(name="c_content")
    @Lob
    private byte[] content;
    @Column(name="c_mimetype")
    private String mimeType;
    @Column(name="c_length")
    private int length;

    @Override
    public byte[] getContent() {
        return this.content;
    }

    public String getContentString() throws UnsupportedEncodingException {
        if (this.content == null) {
            return null;
        }
        String encoding = this.getEncoding();
        if (StringTools.isEmpty((String)encoding)) {
            encoding = CHARSET_UTF_8;
        }
        return new String(this.content, encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public void setContent(byte[] content) {
        if (!this.willChange("content", null, null)) {
            return;
        }
        this.content = content;
        this.length = content == null ? 0 : content.length;
    }

    public void setContentString(String content) {
        if (!this.willChange("content", null, null)) {
            return;
        }
        String encoding = this.getEncoding();
        if (StringTools.isEmpty((String)encoding)) {
            encoding = CHARSET_UTF_8;
        }
        try {
            this.content = content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.content = content.getBytes();
        }
    }

    public void setEncoding(String encoding) {
        if (!this.willChange("encoding", null, null)) {
            return;
        }
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMimeType(String mimeType) {
        if (!this.willChange("mimeType", null, null)) {
            return;
        }
        this.mimeType = mimeType;
    }
}

