/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.file;

import de.intarsys.jpa.common.IdObject;
import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.model.common.file.DBFile;
import de.intarsys.model.common.file.DBFileSystem;
import de.intarsys.model.common.file.DBFolder;
import de.intarsys.model.common.file.DBNode;
import de.intarsys.model.common.file.IDBFile;
import de.intarsys.model.common.file.IDBFolder;
import de.intarsys.model.common.file.IDBNode;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.AbstractLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import jakarta.persistence.EntityManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFileLocator
extends AbstractLocator
implements Serializable {
    private static final Logger Log = LoggerFactory.getLogger(DBFileLocator.class);
    private static final DBNode NONE = new DBFile();
    private static final DBNode FAILED = new DBFile();
    private String path;
    private String name;
    private int folderId = -1;
    private int nodeId = -1;
    private boolean outOfSynch;
    private long lastModified = 0L;
    private transient String cachedPath;
    private transient String cachedName;
    private transient Boolean cachedDirectoryFlag;

    public DBFileLocator(DBFolder folder, String name) {
        this.folderId = folder.getId();
        this.name = name;
    }

    public DBFileLocator(IDBNode node) {
        this.nodeId = ((IdObject)node).getId();
    }

    protected DBFileLocator(int folderId, String name) {
        this.folderId = folderId;
        this.name = name;
    }

    public DBFileLocator(String path) {
        this.path = path;
    }

    protected DBFolder basicGetFolder() {
        return (DBFolder)IdObject.selectById((EntityManager)this.getEntityManager(), DBFolder.class, (int)this.folderId);
    }

    protected DBNode basicGetNode() {
        return (DBNode)IdObject.selectById((EntityManager)this.getEntityManager(), DBNode.class, (int)this.nodeId);
    }

    protected String basicGetPath() {
        return this.path;
    }

    public void delete() throws IOException {
        throw new IOException("not supported");
    }

    public boolean exists() {
        IDBNode tempNode = this.getNode();
        return tempNode != NONE && tempNode != FAILED;
    }

    public ILocator getChild(String name) {
        IDBNode tempNode = this.getNode();
        if (tempNode.isFile()) {
            return null;
        }
        return new DBFileLocator(this.nodeId, name);
    }

    protected EntityManager getEntityManager() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        IDBNode tempNode = this.getNode();
        if (tempNode.isFolder()) {
            throw new IOException("unsupported operation");
        }
        byte[] bytes = ((IDBFile)tempNode).getContent();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        return new ByteArrayInputStream(bytes);
    }

    protected long getLastModified() {
        IDBNode tempNode;
        if (this.lastModified == 0L && (tempNode = this.getNode()) != null) {
            TrackedPersistentObject persistentObject = (TrackedPersistentObject)tempNode;
            this.lastModified = persistentObject.getChanged().getTime();
        }
        return this.lastModified;
    }

    public long getLength() throws IOException {
        IDBNode tempNode = this.getNode();
        if (tempNode.isFolder()) {
            throw new IOException("unsupported operation");
        }
        return ((IDBFile)tempNode).getLength();
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.getNode().getName();
        }
        return FileTools.getFileName((String)this.cachedName);
    }

    public IDBNode getNode() {
        try {
            DBNode result = null;
            if (this.path != null) {
                result = (DBNode)DBFileSystem.get().selectByPath(this.getEntityManager(), this.path);
            } else if (this.folderId != -1) {
                result = (DBNode)this.basicGetFolder().getNode(this.getEntityManager(), this.name);
            } else if (this.nodeId != -1) {
                result = this.basicGetNode();
            }
            if (result == null) {
                return NONE;
            }
            if (this.lastModified == 0L) {
                this.lastModified = result.getChanged().getTime();
            }
            return result;
        }
        catch (Exception e) {
            return FAILED;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                IDBNode tempNode = DBFileLocator.this.getNode();
                ((IDBFile)tempNode).setContent(this.toByteArray());
                DBFileLocator.this.getEntityManager().persist((Object)tempNode);
            }
        };
    }

    public ILocator getParent() {
        IDBFolder tempNode = this.getNode().getParent();
        if (tempNode != null) {
            return new DBFileLocator(tempNode);
        }
        return null;
    }

    public String getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = this.getNode().getPath();
        }
        return this.cachedPath;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        return null;
    }

    public Reader getReader() throws IOException {
        IDBNode tempNode = this.getNode();
        if (tempNode.isFolder()) {
            throw new IOException("unsupported operation");
        }
        return new StringReader(((DBFile)tempNode).getContentString());
    }

    public Reader getReader(String encoding) throws IOException {
        IDBNode tempNode = this.getNode();
        if (tempNode.isFolder()) {
            throw new IOException("unsupported operation");
        }
        byte[] bytes = ((IDBFile)tempNode).getContent();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return new InputStreamReader((InputStream)is, encoding);
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public Writer getWriter(String encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    public boolean isDirectory() {
        if (this.cachedDirectoryFlag == null) {
            this.cachedDirectoryFlag = this.getNode().isFolder();
        }
        return this.cachedDirectoryFlag;
    }

    public synchronized boolean isOutOfSynch() {
        this.synch();
        return this.outOfSynch;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        IDBNode tempNode = this.getNode();
        if (tempNode.isFolder()) {
            IDBFolder folder = (IDBFolder)tempNode;
            List<IDBNode> children = folder.getNodes();
            ArrayList<DBFileLocator> childLocators = new ArrayList<DBFileLocator>(children.size());
            for (IDBNode child : children) {
                if (!filter.accept((ILocator)this, child.getName())) continue;
                DBFileLocator childLocator = new DBFileLocator(child);
                childLocators.add(childLocator);
            }
            return childLocators.toArray(new ILocator[childLocators.size()]);
        }
        return null;
    }

    public void rename(String newName) throws IOException {
    }

    public void setReadOnly() {
    }

    public synchronized void synch() {
        if (this.outOfSynch) {
            return;
        }
        IDBNode tempNode = this.getNode();
        if (tempNode == null) {
            return;
        }
        TrackedPersistentObject persistentObject = (TrackedPersistentObject)tempNode;
        if (this.getLastModified() != persistentObject.getChanged().getTime()) {
            Log.trace("'" + tempNode.getName() + "' out of synch!");
            this.outOfSynch = true;
        }
    }

    public URI toURI() {
        return null;
    }
}

