/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.file;

import de.intarsys.model.common.file.DBFolder;
import de.intarsys.model.common.file.IDBFile;
import de.intarsys.model.common.file.IDBFolder;
import de.intarsys.model.common.file.IDBNode;
import de.intarsys.tools.component.SingletonClass;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.io.IOException;
import java.util.List;

@SingletonClass
public class DBFileSystem {
    private static final DBFileSystem ACTIVE = new DBFileSystem();
    private static final String ROOTNAME = "de.intarsys.filesystem.root";
    public static final String SEPARATOR = "/";

    public static DBFileSystem get() {
        return ACTIVE;
    }

    public IDBFile createFile(EntityManager em, String path) throws IOException {
        if (!path.startsWith(SEPARATOR)) {
            throw new IOException("path must be absolute");
        }
        IDBFolder folder = this.selectRoot(em);
        return ((DBFolder)folder).createFile(em, path.substring(1));
    }

    public IDBFolder createFolder(EntityManager em, String path) throws IOException {
        if (!path.startsWith(SEPARATOR)) {
            throw new IOException("path must be absolute");
        }
        IDBFolder folder = this.selectRoot(em);
        return ((DBFolder)folder).createFolder(em, path.substring(1));
    }

    protected DBFolder createRoot(EntityManager em) {
        DBFolder root = new DBFolder();
        root.setName(ROOTNAME);
        em.persist((Object)root);
        return root;
    }

    public void initialize(EntityManager em) {
        try {
            this.selectRoot(em);
        }
        catch (Exception e) {
            this.createRoot(em);
        }
    }

    public IDBNode selectByPath(EntityManager em, String path) {
        if (path.startsWith(SEPARATOR)) {
            return this.selectRoot(em).getNode(em, path.substring(1));
        }
        return this.selectRoot(em).getNode(em, path);
    }

    public IDBFolder selectRoot(EntityManager em) {
        Query query = em.createQuery("SELECT x FROM DBFolder x WHERE x.parent IS NULL AND x.name = :name");
        query.setParameter("name", (Object)ROOTNAME);
        List objects = query.getResultList();
        if (objects.size() == 0) {
            throw new IllegalStateException("filesystem root not found");
        }
        return (DBFolder)objects.get(0);
    }
}

