/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.file;

import de.intarsys.model.common.file.DBFile;
import de.intarsys.model.common.file.DBFileSystem;
import de.intarsys.model.common.file.DBNode;
import de.intarsys.model.common.file.IDBFile;
import de.intarsys.model.common.file.IDBFolder;
import de.intarsys.model.common.file.IDBNode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="t_dbfolder")
@DiscriminatorValue(value="D")
@PrimaryKeyJoinColumn(name="fk_dbnode")
public class DBFolder
extends DBNode
implements IDBFolder {
    @OneToMany(targetEntity=DBNode.class, fetch=FetchType.LAZY, mappedBy="parent", cascade={CascadeType.ALL})
    private List<IDBNode> nodes = new ArrayList<IDBNode>();

    @Override
    public void addNode(IDBNode node) {
        if (this.nodes.contains(node)) {
            return;
        }
        this.basicAddNode(node);
        ((DBNode)node).basicSetParent(this);
    }

    public void basicAddNode(IDBNode node) {
        if (!this.willChange("nodes", null, null)) {
            return;
        }
        this.nodes.add(node);
    }

    public void basicRemoveNode(IDBNode node) {
        if (!this.willChange("nodes", null, null)) {
            return;
        }
        this.nodes.remove(node);
    }

    @Override
    public IDBFile createFile(EntityManager em, String path) throws IOException {
        if (path.startsWith("/")) {
            return DBFileSystem.get().createFile(em, path);
        }
        String[] segments = path.split("/", 2);
        IDBNode tempNode = this.getNode(em, segments[0]);
        if (segments.length == 2) {
            if (tempNode == null) {
                tempNode = new DBFolder();
                tempNode.setName(segments[0]);
                em.persist((Object)tempNode);
                this.addNode(tempNode);
            }
            if (tempNode.isFolder()) {
                return ((IDBFolder)tempNode).createFile(em, segments[1]);
            }
            throw new IOException("node '" + tempNode.getName() + "' not a folder");
        }
        if (tempNode == null) {
            tempNode = new DBFile();
            tempNode.setName(segments[0]);
            em.persist((Object)tempNode);
            this.addNode(tempNode);
        }
        if (tempNode.isFolder()) {
            throw new IOException("node '" + tempNode.getName() + "' not a file");
        }
        return (IDBFile)tempNode;
    }

    @Override
    public IDBFolder createFolder(EntityManager em, String path) throws IOException {
        if (path.startsWith("/")) {
            return DBFileSystem.get().createFolder(em, path);
        }
        String[] segments = path.split("/", 2);
        IDBNode tempNode = this.getNode(em, segments[0]);
        if (segments.length == 2) {
            if (tempNode == null) {
                tempNode = new DBFolder();
                tempNode.setName(segments[0]);
                em.persist((Object)tempNode);
                this.addNode(tempNode);
            }
            if (tempNode.isFolder()) {
                return ((IDBFolder)tempNode).createFolder(em, segments[1]);
            }
            throw new IOException("node '" + tempNode.getName() + "' not a folder");
        }
        if (tempNode == null) {
            tempNode = new DBFolder();
            tempNode.setName(segments[0]);
            em.persist((Object)tempNode);
            this.addNode(tempNode);
        }
        if (tempNode.isFolder()) {
            return (IDBFolder)tempNode;
        }
        throw new IOException("node '" + tempNode.getName() + "' not a folder");
    }

    @Override
    public IDBNode getNode(EntityManager em, String path) {
        if (path.startsWith("/")) {
            return DBFileSystem.get().selectByPath(em, path);
        }
        String[] segments = path.split("/", 2);
        IDBNode tempNode = null;
        for (IDBNode node : this.nodes) {
            if (!node.getName().equals(segments[0])) continue;
            tempNode = node;
            break;
        }
        if (tempNode == null) {
            return null;
        }
        if (segments.length == 2) {
            if (tempNode.isFolder()) {
                return ((DBFolder)tempNode).getNode(em, segments[1]);
            }
            return null;
        }
        return tempNode;
    }

    @Override
    public List<IDBNode> getNodes() {
        return this.nodes;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void removeNode(IDBNode node) {
        if (!this.nodes.contains(node)) {
            return;
        }
        this.basicRemoveNode(node);
        ((DBNode)node).basicSetParent(null);
    }
}

