/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.file;

import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.model.common.file.DBFolder;
import de.intarsys.model.common.file.IDBFolder;
import de.intarsys.model.common.file.IDBNode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="t_dbnode")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="c_type", discriminatorType=DiscriminatorType.CHAR)
public abstract class DBNode
extends TrackedPersistentObject
implements IDBNode {
    @ManyToOne(fetch=FetchType.LAZY, optional=true, cascade={CascadeType.MERGE})
    @JoinColumn(name="fk_parent", nullable=true)
    private DBFolder parent;
    @Column(name="c_name")
    private String name;

    public void basicSetParent(DBFolder value) {
        if (!this.willChange("parent", null, null)) {
            return;
        }
        this.parent = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IDBFolder getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        StringBuilder sb = new StringBuilder();
        this.getPath(sb);
        return sb.toString();
    }

    protected void getPath(StringBuilder sb) {
        if (this.getParent() != null) {
            ((DBFolder)this.getParent()).getPath(sb);
        }
        sb.append("/");
        sb.append(this.getName());
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void setName(String name) {
        if (!this.willChange("name", null, null)) {
            return;
        }
        this.name = name;
    }

    public void setParent(DBFolder value) {
        if (this.parent == value) {
            return;
        }
        if (this.parent != null) {
            this.parent.basicRemoveNode(this);
        }
        this.basicSetParent(value);
        if (this.parent != null) {
            this.parent.basicAddNode(this);
        }
    }
}

