/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.prefs;

import de.intarsys.jpa.common.IdObject;
import de.intarsys.model.common.prefs.Node;
import de.intarsys.model.common.prefs.Property;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class DBPreferencesImpl
extends AbstractPreferences {
    private Node node;

    protected DBPreferencesImpl(DBPreferencesImpl parent, Node node) {
        super(parent, parent == null ? "" : node.getName());
        this.node = node;
    }

    protected Node basicGetNode() {
        if (!this.node.isPersistent()) {
            return this.node;
        }
        this.node = (Node)IdObject.selectById((EntityManager)this.getEntityManager(), Node.class, (int)this.node.getId());
        return this.node;
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        List<Node> children = tempNode.getNodes();
        String[] result = new String[children.size()];
        int i = 0;
        for (Node child : children) {
            result[i++] = child.getName();
        }
        return result;
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        List<Node> children = tempNode.getNodes();
        Node selectedNode = null;
        for (Node child : children) {
            if (!child.getName().equals(name)) continue;
            selectedNode = child;
        }
        if (selectedNode == null) {
            selectedNode = new Node();
            selectedNode.setName(name);
            selectedNode.setParent(tempNode);
            this.getEntityManager().persist((Object)selectedNode);
        }
        return new DBPreferencesImpl(this, selectedNode);
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    protected EntityManager getEntityManager() {
        return null;
    }

    @Override
    protected String getSpi(String key) {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        List<Property> properties = tempNode.getProperties();
        for (Property property : properties) {
            if (!property.getName().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        List<Property> properties = tempNode.getProperties();
        String[] result = new String[properties.size()];
        int i = 0;
        for (Property property : properties) {
            result[i++] = property.getName();
        }
        return result;
    }

    @Override
    protected void putSpi(String key, String value) {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        List<Property> properties = tempNode.getProperties();
        for (Property property : properties) {
            if (!property.getName().equals(key)) continue;
            property.setValue(value);
            this.getEntityManager().persist((Object)property);
            return;
        }
        Property newProperty = new Property();
        newProperty.setNode(tempNode);
        newProperty.setName(key);
        newProperty.setValue(value);
        this.getEntityManager().persist((Object)newProperty);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        this.getEntityManager().remove((Object)tempNode);
    }

    @Override
    protected void removeSpi(String key) {
        Node tempNode = this.basicGetNode();
        if (tempNode == null) {
            throw new IllegalStateException();
        }
        List<Property> properties = tempNode.getProperties();
        for (Property property : properties) {
            if (!property.getName().equals(key)) continue;
            this.getEntityManager().remove((Object)property);
            return;
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

