/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.prefs;

import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.model.common.prefs.Property;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="t_prefsnode")
public class Node
extends TrackedPersistentObject {
    @OneToMany(fetch=FetchType.LAZY, mappedBy="node", cascade={CascadeType.ALL})
    private List<Property> properties = new ArrayList<Property>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parent", cascade={CascadeType.ALL})
    private List<Node> nodes = new ArrayList<Node>();
    @ManyToOne(fetch=FetchType.LAZY, optional=true, cascade={CascadeType.MERGE})
    @JoinColumn(name="fk_prefsnode", nullable=true)
    private Node parent;
    @Column(name="c_name", nullable=false)
    private String name;

    public void addNode(Node node) {
        if (this.nodes.contains((Object)node)) {
            return;
        }
        this.basicAddNode(node);
        node.basicSetParent(this);
    }

    public void basicAddNode(Node node) {
        if (!this.willChange("nodes", null, null)) {
            return;
        }
        this.nodes.add(node);
    }

    public void basicAddProperty(Property property) {
        if (!this.willChange("properties", null, null)) {
            return;
        }
        this.properties.add(property);
    }

    public void basicRemoveNode(Node node) {
        if (!this.willChange("nodes", null, null)) {
            return;
        }
        this.nodes.remove((Object)node);
    }

    public void basicRemoveProperty(Property property) {
        if (!this.willChange("properties", null, null)) {
            return;
        }
        this.properties.remove((Object)property);
    }

    public void basicSetParent(Node value) {
        if (!this.willChange("parent", null, null)) {
            return;
        }
        this.parent = value;
    }

    public String getName() {
        return this.name;
    }

    public Node getNode(String path) {
        if (path.startsWith("/")) {
            return null;
        }
        String[] segments = path.split("/", 2);
        Node tempNode = null;
        for (Node node : this.nodes) {
            if (!node.getName().equals(segments[0])) continue;
            tempNode = node;
            break;
        }
        if (tempNode == null) {
            return null;
        }
        if (segments.length == 2) {
            return tempNode.getNode(segments[1]);
        }
        return tempNode;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void removeNode(Node node) {
        if (!this.nodes.contains((Object)node)) {
            return;
        }
        this.basicRemoveNode(node);
        node.basicSetParent(null);
    }

    public void setName(String name) {
        if (!this.willChange("name", null, null)) {
            return;
        }
        this.name = name;
    }

    public void setParent(Node value) {
        if (this.parent == value) {
            return;
        }
        if (this.parent != null) {
            this.parent.basicRemoveNode(this);
        }
        this.basicSetParent(value);
        if (this.parent != null) {
            this.parent.basicAddNode(this);
        }
    }
}

