/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.prefs;

import de.intarsys.model.common.prefs.Node;
import de.intarsys.tools.component.SingletonClass;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;

@SingletonClass
public class PreferencesSystem {
    private static final PreferencesSystem ACTIVE = new PreferencesSystem();
    private static final String ROOTNAME = "de.intarsys.preferences.root";
    public static final String SEPARATOR = "/";

    public static PreferencesSystem get() {
        return ACTIVE;
    }

    protected Node createRoot(EntityManager em) {
        Node root = new Node();
        root.setName(ROOTNAME);
        em.persist((Object)this);
        return root;
    }

    public void initialize(EntityManager em) {
        try {
            this.selectRoot(em);
        }
        catch (Exception e) {
            this.createRoot(em);
        }
    }

    public Node selectByPath(EntityManager em, String path) {
        if (path.startsWith(SEPARATOR)) {
            return this.selectRoot(em).getNode(path.substring(1));
        }
        return this.selectRoot(em).getNode(path);
    }

    public Node selectRoot(EntityManager em) {
        Query query = em.createQuery("SELECT x FROM Node x WHERE x.parent IS NULL AND x.name = :name");
        query.setParameter("name", (Object)ROOTNAME);
        List objects = query.getResultList();
        if (objects.size() == 0) {
            throw new IllegalStateException("preferences root not found");
        }
        return (Node)((Object)objects.get(0));
    }
}

