/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.security;

import de.intarsys.jpa.common.IdObject;
import de.intarsys.model.common.security.ServiceInformation;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;

@Entity
@Table(name="t_certificate")
public class Certificate
extends IdObject
implements IAttributeSupport {
    public static String TYPE_X509 = "X509";
    @Column(name="c_type", nullable=false)
    private String type = TYPE_X509;
    @Column(name="c_subject", nullable=false)
    private String subject;
    @Column(name="c_issuer", nullable=false)
    private String issuer;
    @Column(name="c_serial", nullable=false)
    private String serial;
    @Column(name="c_subjectkeyidentifier")
    private String subjectKeyIdentifier;
    @Column(name="c_certificate", nullable=false)
    private byte[] certificate;
    @OneToOne(mappedBy="certificate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private ServiceInformation serviceInformation;
    @Transient
    private AttributeMap attributes = new AttributeMap();

    public static Certificate select(EntityManager em, String serial) {
        Query query = em.createQuery("SELECT o FROM Certificate o WHERE o.serial = :serial");
        query.setParameter("serial", (Object)serial);
        List objects = query.getResultList();
        if (objects.size() > 0) {
            return (Certificate)((Object)objects.get(0));
        }
        return null;
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSerial() {
        return this.serial;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public String getType() {
        return this.type;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setCertificate(byte[] data) {
        if (!this.willChange("certificate", null, null)) {
            return;
        }
        this.certificate = data;
    }

    public void setIssuer(String issuer) {
        if (!this.willChange("issuer", null, null)) {
            return;
        }
        this.issuer = issuer;
    }

    public void setSerial(String serial) {
        if (!this.willChange("serial", null, null)) {
            return;
        }
        this.serial = serial;
    }

    public void setServiceInformation(ServiceInformation serviceInformation) {
        if (this.willChange("serviceInformation", null, null)) {
            this.serviceInformation = serviceInformation;
            if (serviceInformation != null) {
                serviceInformation.setCertificate(this);
            }
        }
    }

    public void setSubject(String subject) {
        if (!this.willChange("subject", null, null)) {
            return;
        }
        this.subject = subject;
    }

    public void setSubjectKeyIdentifier(String subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public void setType(String type) {
        if (!this.willChange("type", null, null)) {
            return;
        }
        this.type = type;
    }
}

