/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.security;

import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.model.common.security.User;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="t_credential")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="c_type", discriminatorType=DiscriminatorType.CHAR)
public class Credential
extends TrackedPersistentObject {
    public static final String CONTEXT_AUTHENTICATE = "authenticate";
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="fk_user", nullable=false)
    @Deprecated
    private User user;
    @Temporal(value=TemporalType.DATE)
    @Column(name="c_valid_from", nullable=true)
    private Date validFrom;
    @Temporal(value=TemporalType.DATE)
    @Column(name="c_valid_to", nullable=true)
    private Date validTo;
    @Column(name="c_context")
    private String context;

    protected Credential() {
    }

    public void basicSetUser(User pUser) {
        if (!this.willChange("user", null, null)) {
            return;
        }
        this.user = pUser;
    }

    public String getContext() {
        return this.context;
    }

    public User getUser() {
        return this.user;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setContext(String context) {
        if (!this.willChange("context", null, null)) {
            return;
        }
        this.context = context;
    }

    public void setUser(User pUser) {
        if (this.user == pUser) {
            return;
        }
        if (this.user != null) {
            this.user.basicRemoveCredential(this);
        }
        this.basicSetUser(pUser);
        if (this.user != null) {
            this.user.basicAddCredential(this);
        }
    }

    public void setValidFrom(Date validFrom) {
        if (!this.willChange("validFrom", null, null)) {
            return;
        }
        this.validFrom = validFrom;
    }

    public void setValidTo(Date pValidTo) {
        if (!this.willChange("validTo", null, null)) {
            return;
        }
        this.validTo = pValidTo;
    }
}

