/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.security;

import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.model.common.security.Permission;
import de.intarsys.model.common.security.User;
import de.intarsys.tools.lang.LangTools;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="t_group")
public class Group
extends TrackedPersistentObject {
    @OneToMany(fetch=FetchType.LAZY, mappedBy="group", cascade={CascadeType.ALL})
    private final List<Permission> permissions = new ArrayList<Permission>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="groups", cascade={CascadeType.ALL})
    @JoinTable(name="t_user_group", joinColumns={@JoinColumn(name="fk_group", referencedColumnName="c_id")}, inverseJoinColumns={@JoinColumn(name="fk_user", referencedColumnName="c_id")})
    private final List<User> users = new ArrayList<User>();
    @Column(name="c_name", nullable=false)
    private String name;
    @Column(name="c_administrator", nullable=false)
    private boolean administrator = false;

    public static List<Group> all(EntityManager em) {
        Query query = em.createQuery("SELECT r FROM Group r");
        List objects = query.getResultList();
        return objects;
    }

    public static Group create() {
        Group object = new Group();
        return object;
    }

    public static Group select(EntityManager em, String name) {
        Query query = em.createQuery("SELECT r FROM Group r WHERE r.name = :name");
        query.setParameter("name", (Object)name);
        List objects = query.getResultList();
        if (objects.size() > 0) {
            return (Group)((Object)objects.get(0));
        }
        return null;
    }

    public void addPermission(Permission permission) {
        if (this.permissions.contains((Object)permission)) {
            return;
        }
        this.basicAddPermission(permission);
        permission.basicSetGroup(this);
    }

    public void addUser(User user) {
        if (this.users.contains((Object)user)) {
            return;
        }
        this.basicAddUser(user);
        user.basicAddGroup(this);
    }

    public void basicAddPermission(Permission permission) {
        if (!this.willChange("permissions", null, null)) {
            return;
        }
        this.permissions.add(permission);
    }

    public void basicAddUser(User user) {
        if (!this.willChange("users", null, null)) {
            return;
        }
        this.users.add(user);
    }

    public void basicRemovePermission(Permission permission) {
        if (!this.willChange("permissions", null, null)) {
            return;
        }
        this.permissions.remove((Object)permission);
    }

    public void basicRemoveUser(User user) {
        if (!this.willChange("users", null, null)) {
            return;
        }
        this.users.remove((Object)user);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        return LangTools.equals((Object)((Group)((Object)obj)).getId(), (Object)this.getId());
    }

    public String getName() {
        return this.name;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean isAdministrator() {
        return this.administrator;
    }

    public void removePermission(Permission permission) {
        if (!this.permissions.contains((Object)permission)) {
            return;
        }
        this.basicRemovePermission(permission);
        permission.basicSetGroup(null);
    }

    public void removeUser(User user) {
        if (!this.users.contains((Object)user)) {
            return;
        }
        this.basicRemoveUser(user);
        user.basicRemoveGroup(this);
    }

    public void setAdministrator(boolean administrator) {
        if (!this.willChange("administrator", null, null)) {
            return;
        }
        this.administrator = administrator;
    }

    public void setName(String name) {
        if (!this.willChange("entity", null, null)) {
            return;
        }
        this.name = name;
    }
}

