/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.security;

import de.intarsys.model.common.security.Credential;
import de.intarsys.tools.authenticate.PasswordTools;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;

@Entity
@Table(name="t_credentialpassword")
@DiscriminatorValue(value="P")
@PrimaryKeyJoinColumn(name="fk_credential")
public class PasswordCredential
extends Credential {
    @Column(name="c_salt", nullable=false)
    private String salt;
    @Column(name="c_password", nullable=false)
    private String password;

    public String getPassword() {
        return this.password;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setPasswordDecoded(String password) {
        String hash = PasswordTools.hash((String)this.getSalt(), (char[])password.toCharArray());
        this.setPasswordEncoded(hash);
    }

    public void setPasswordEncoded(String password) {
        if (!this.willChange("password", null, null)) {
            return;
        }
        this.password = password;
    }

    public void setSalt(String salt) {
        if (!this.willChange("salt", null, null)) {
            return;
        }
        this.salt = salt;
    }
}

