/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.security;

import de.intarsys.jpa.common.IdObject;
import de.intarsys.model.common.security.Certificate;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import java.util.List;

@Entity
@Table(name="t_serviceinformation")
public class ServiceInformation
extends IdObject {
    public static final String TYPE_UNSPECIFIED = "http://uri.etsi.org/TrstSvc/Svctype/unspecified";
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="fk_certificate", nullable=false)
    private Certificate certificate;
    @Column(name="c_type", nullable=false)
    private String type = "http://uri.etsi.org/TrstSvc/Svctype/unspecified";
    @Column(name="c_name", nullable=false)
    private String name;

    public static ServiceInformation select(EntityManager em, String type) {
        Query query = em.createQuery("SELECT o FROM ServiceInformation o WHERE o.type = :type");
        query.setParameter("type", (Object)type);
        List objects = query.getResultList();
        if (objects.size() > 0) {
            return (ServiceInformation)((Object)objects.get(0));
        }
        return null;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setCertificate(Certificate certificate) {
        if (this.willChange("certificate", null, null)) {
            this.certificate = certificate;
        }
    }

    public void setName(String name) {
        if (!this.willChange("name", null, null)) {
            return;
        }
        this.name = name;
    }

    public void setType(String type) {
        if (!this.willChange("type", null, null)) {
            return;
        }
        this.type = type;
    }
}

