/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.security;

import de.intarsys.aaa.permission.IPermission;
import de.intarsys.jpa.common.IdObject;
import de.intarsys.jpa.common.JPAModelTools;
import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.model.common.security.Credential;
import de.intarsys.model.common.security.Group;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="t_user")
public class User
extends TrackedPersistentObject {
    @Transient
    private IdObject principal;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="t_user_credential", joinColumns={@JoinColumn(name="fk_user", referencedColumnName="c_id")}, inverseJoinColumns={@JoinColumn(name="fk_credential", referencedColumnName="c_id")})
    private final List<Credential> credentials = new ArrayList<Credential>();
    @Column(name="c_locked", nullable=false)
    private boolean locked = false;
    @Column(name="c_administrator", nullable=false)
    private boolean administrator = false;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="t_user_group", joinColumns={@JoinColumn(name="fk_user", referencedColumnName="c_id")}, inverseJoinColumns={@JoinColumn(name="fk_group", referencedColumnName="c_id")})
    private final List<Group> groups = new ArrayList<Group>();
    @Column(name="c_name", nullable=false)
    private String name;
    @Column(name="c_email")
    private String email;
    @Column(name="c_principal_type")
    private String principalType;
    @Column(name="c_principal_id")
    private int principalId;

    public static List<User> all(EntityManager em) {
        Query query = em.createQuery("SELECT x FROM User x");
        List objects = query.getResultList();
        return objects;
    }

    public static int countAll(EntityManager em) {
        Query query = em.createQuery("select count(x) from User x");
        return ((Number)query.getSingleResult()).intValue();
    }

    public static int countUnlocked(EntityManager em) {
        Query query = em.createQuery("select count(x) from User x where x.locked = false");
        return ((Number)query.getSingleResult()).intValue();
    }

    public static User create() {
        User object = new User();
        return object;
    }

    public static User select(EntityManager em, String name) {
        Query query = em.createQuery("SELECT u FROM User u WHERE u.name = :name");
        query.setParameter("name", (Object)name);
        List objects = query.getResultList();
        if (!objects.isEmpty()) {
            return (User)((Object)objects.get(0));
        }
        return null;
    }

    public void addCredential(Credential credential) {
        if (this.credentials.contains((Object)credential)) {
            return;
        }
        this.basicAddCredential(credential);
    }

    public void addGroup(Group group) {
        if (this.groups.contains((Object)group)) {
            return;
        }
        this.basicAddGroup(group);
        group.basicAddUser(this);
    }

    public void basicAddCredential(Credential credential) {
        if (!this.willChange("credentials", null, null)) {
            return;
        }
        this.credentials.add(credential);
    }

    public void basicAddGroup(Group group) {
        if (!this.willChange("groups", null, null)) {
            return;
        }
        this.groups.add(group);
    }

    public void basicRemoveCredential(Credential credential) {
        if (!this.willChange("credentials", null, null)) {
            return;
        }
        this.credentials.remove((Object)credential);
    }

    public void basicRemoveGroup(Group group) {
        if (!this.willChange("groups", null, null)) {
            return;
        }
        this.groups.remove((Object)group);
    }

    public void checkUndeclaredAssociations() {
        this.updatePrincipalReference();
        super.checkUndeclaredAssociations();
    }

    protected IdObject derivePrincipal(EntityManager em) {
        if (this.getPrincipalType() == null) {
            return null;
        }
        return IdObject.selectById((EntityManager)em, (String)this.getPrincipalType(), (int)this.getPrincipalId());
    }

    public Credential getCredential(String context) {
        for (Credential credential : this.getCredentials()) {
            if (!context.equals(credential.getContext())) continue;
            return credential;
        }
        return null;
    }

    public <T extends Credential> T getCredential(String context, Class<T> clazz) {
        for (Credential credential : this.getCredentials()) {
            if (!context.equals(credential.getContext()) || !clazz.isInstance((Object)credential)) continue;
            return (T)((Object)credential);
        }
        return null;
    }

    public List<Credential> getCredentials() {
        return this.credentials;
    }

    public String getEmail() {
        return this.email;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        if (this.getEmail() != null) {
            sb.append(" - ");
            sb.append(this.getEmail());
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public List<IPermission> getPermissions() {
        ArrayList<IPermission> permissions = new ArrayList<IPermission>();
        for (Group group : this.getGroups()) {
            permissions.addAll(group.getPermissions());
        }
        return permissions;
    }

    public IdObject getPrincipal(EntityManager em) {
        if (this.principal == null) {
            this.principal = this.derivePrincipal(em);
        }
        return this.principal;
    }

    public int getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public boolean isAdministrator() {
        return this.administrator;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void removeCredential(Credential credential) {
        if (!this.credentials.contains((Object)credential)) {
            return;
        }
        this.basicRemoveCredential(credential);
    }

    public void removeGroup(Group group) {
        if (!this.groups.contains((Object)group)) {
            return;
        }
        this.basicRemoveGroup(group);
        group.basicRemoveUser(this);
    }

    public void setAdministrator(boolean administrator) {
        if (!this.willChange("administrator", null, null)) {
            return;
        }
        this.administrator = administrator;
    }

    public void setEmail(String email) {
        if (!this.willChange("email", null, null)) {
            return;
        }
        this.email = email;
    }

    public void setLocked(boolean locked) {
        if (!this.willChange("locked", null, null)) {
            return;
        }
        this.locked = locked;
    }

    public void setName(String name) {
        if (!this.willChange("name", null, null)) {
            return;
        }
        this.name = name;
    }

    public void setPrincipal(IdObject pPrincipal) {
        if (!this.willChange("principal", null, null)) {
            return;
        }
        if (this.principal == pPrincipal) {
            return;
        }
        this.principal = pPrincipal;
        this.updatePrincipalReference();
    }

    public void setPrincipalId(int entityId) {
        if (!this.willChange("principalId", null, null)) {
            return;
        }
        this.principalId = entityId;
        this.principal = null;
    }

    public void setPrincipalType(String entityType) {
        if (!this.willChange("principalType", null, null)) {
            return;
        }
        this.principalType = entityType;
        this.principal = null;
    }

    protected void updatePrincipalReference() {
        if (this.principal == null) {
            this.principalType = null;
            this.principalId = -1;
        } else {
            this.principalType = JPAModelTools.getEntityAlias(this.principal.getClass());
            this.principalId = this.principal.getId();
        }
    }
}

