/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.model.common.tag;

import de.intarsys.jpa.common.AttachedPersistentObject;
import de.intarsys.jpa.common.IdObject;
import de.intarsys.jpa.common.JPAModelTools;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.List;

@Entity
@Table(name="t_tag")
public class Tag
extends AttachedPersistentObject<IdObject> {
    @Column(name="c_name")
    private String name;
    @Column(name="c_value")
    private String value;

    public static List<Tag> selectByOwner(EntityManager em, IdObject owner, String tagName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String entityType = JPAModelTools.getEntityAlias(owner.getClass());
        int entityId = owner.getId();
        parameters.put("entityType", entityType);
        parameters.put("entityId", entityId);
        parameters.put("name", tagName);
        return Tag.query((EntityManager)em, Tag.class, parameters);
    }

    public static Tag selectSingleByOwner(EntityManager em, IdObject owner, String tagName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String entityType = JPAModelTools.getEntityAlias(owner.getClass());
        int entityId = owner.getId();
        parameters.put("entityType", entityType);
        parameters.put("entityId", entityId);
        parameters.put("name", tagName);
        return (Tag)((Object)Tag.querySingle((EntityManager)em, Tag.class, parameters));
    }

    public static Tag selectSingleByOwner(EntityManager em, IdObject owner, String tagName, String tagValue) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String entityType = JPAModelTools.getEntityAlias(owner.getClass());
        int entityId = owner.getId();
        parameters.put("entityType", entityType);
        parameters.put("entityId", entityId);
        parameters.put("name", tagName);
        parameters.put("value", tagValue);
        return (Tag)((Object)Tag.querySingle((EntityManager)em, Tag.class, parameters));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        if (!this.willChange("name", null, null)) {
            return;
        }
        this.name = name;
    }

    public void setValue(String value) {
        if (!this.willChange("value", null, null)) {
            return;
        }
        this.value = value;
    }
}

