/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.bridglet;

import de.intarsys.cloudsuite.meeting.bridglet.BridgletLicenseTools;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.core.MeetingHandlerAdapter;
import de.intarsys.tools.exception.EncodedException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.License;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BridgletHandler
extends MeetingHandlerAdapter {
    private final IArgs args;
    private IArgs result;
    private IArgs outcomeArgs;
    private String outcomeState;
    private Exception outcomeException;
    private final IZone zone;

    public BridgletHandler(IArgs args) {
        this.args = args;
        this.zone = Zone.getCurrent();
    }

    protected Object basicCall(IMeeting meeting, IParticipant participant, String name, IArgs args) throws Exception {
        if ("getParameters".equals(name)) {
            return this.onGetParameters();
        }
        if ("postEvent".equals(name)) {
            return this.onPostEvent(meeting, participant, args);
        }
        if ("setResult".equals(name)) {
            return this.onSetResult(args);
        }
        if ("getResult".equals(name)) {
            return this.onGetResult(args);
        }
        return super.call(meeting, participant, name, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object call(IMeeting meeting, IParticipant participant, String name, IArgs args) throws Exception {
        this.zone.enter();
        try {
            Object object = this.basicCall(meeting, participant, name, args);
            return object;
        }
        finally {
            this.zone.leave();
        }
    }

    @Override
    protected boolean checkParticipants(IMeeting meeting) {
        return meeting.getParticipants().size() >= this.getRequiredParticipantCount();
    }

    protected IArgs createExceptionArgs(String code, String message) {
        Args exArgs = Args.create();
        ArgTools.putPath((IArgs)exArgs, (String)"name", (Object)"fail");
        ArgTools.putPath((IArgs)exArgs, (String)"error.code", (Object)code);
        ArgTools.putPath((IArgs)exArgs, (String)"error.message", (Object)message);
        return exArgs;
    }

    protected Collection<License> getAdditionalLicenses() {
        return Collections.emptySet();
    }

    protected IArgs getBridgeArgs() {
        return ArgTools.getArgs((IArgs)this.args, (String)"bridge", (IArgs)Args.create());
    }

    protected IArgs getBridgletArgs() {
        return ArgTools.getArgs((IArgs)this.args, (String)"bridglet", (IArgs)Args.create());
    }

    protected final ILocator getLicense() {
        return BridgletLicenseTools.getLicenses(this.getAdditionalLicenses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IArgs getOutcomeArgs() {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            return this.outcomeArgs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getOutcomeException() {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            return this.outcomeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutcomeState() {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            return this.outcomeState;
        }
    }

    protected int getRequiredParticipantCount() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IArgs getResult() {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            return this.result;
        }
    }

    protected void hookOutcomeCancel(IMeeting meeting) throws Exception {
    }

    protected void hookOutcomeFail(IMeeting meeting) throws Exception {
    }

    protected void hookOutcomeOk(IMeeting meeting) throws Exception {
    }

    public boolean isCanceled() {
        return "cancel".equals(this.getOutcomeState());
    }

    public boolean isDone() {
        return this.getOutcomeState() != null;
    }

    public boolean isFailed() {
        return "fail".equals(this.getOutcomeState());
    }

    public boolean isOk() {
        return "ok".equals(this.getOutcomeState());
    }

    @Override
    public void onError(IMeeting meeting, String code, String message) {
        this.onOutcomeFail(meeting, code, message);
    }

    protected IArgs onGetParameters() {
        Args params = Args.create();
        IArgs bridgeArgs = this.getBridgeArgs();
        params.put("bridge", (Object)bridgeArgs);
        ArgTools.putPathIfAbsent((IArgs)bridgeArgs, (String)"license", (Object)this.getLicense());
        IArgs bridgletArgs = this.getBridgletArgs();
        params.put("bridglet", (Object)bridgletArgs);
        return params;
    }

    protected IArgs onGetResult(IArgs args) {
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOutcomeCancel(IMeeting meeting) {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            if (this.isDone()) {
                return;
            }
            try {
                this.outcomeState = "cancel";
                this.outcomeArgs = Args.create();
                this.hookOutcomeCancel(meeting);
                this.onOutcomeFinally(meeting);
            }
            catch (Exception e) {
                this.onOutcomeFail(meeting, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOutcomeFail(IMeeting meeting, Exception ex) {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            if (this.isDone()) {
                return;
            }
            try {
                this.outcomeState = "fail";
                BridgletHandler bridgletHandler2 = this;
                synchronized (bridgletHandler2) {
                    this.outcomeException = ex;
                }
                String code = ExceptionTools.getCode((Throwable)ex);
                String message = ExceptionTools.getMessage((Throwable)ex);
                this.outcomeArgs = this.createExceptionArgs(code, message);
                this.hookOutcomeFail(meeting);
            }
            catch (Exception exception) {
            }
            finally {
                this.onOutcomeFinally(meeting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOutcomeFail(IMeeting meeting, String code, String message) {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            if (this.isDone()) {
                return;
            }
            try {
                this.outcomeState = "fail";
                BridgletHandler bridgletHandler2 = this;
                synchronized (bridgletHandler2) {
                    this.outcomeException = new EncodedException(code, message);
                }
                this.outcomeArgs = this.createExceptionArgs(code, message);
                this.hookOutcomeFail(meeting);
            }
            catch (Exception exception) {
            }
            finally {
                this.onOutcomeFinally(meeting);
            }
        }
    }

    protected void onOutcomeFinally(IMeeting meeting) {
        try {
            meeting.postEvent(this.outcomeState, this.outcomeArgs);
        }
        finally {
            meeting.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOutcomeOk(IMeeting meeting) {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            if (this.isDone()) {
                return;
            }
            try {
                this.outcomeState = "ok";
                this.outcomeArgs = Args.create();
                this.hookOutcomeOk(meeting);
                this.onOutcomeFinally(meeting);
            }
            catch (Exception e) {
                this.onOutcomeFail(meeting, e);
            }
        }
    }

    protected Object onPostEvent(IMeeting meeting, IParticipant participant, IArgs args) throws Exception {
        String eventName = ArgTools.getString((IArgs)args, (String)"name", null);
        if ("ok".equals(eventName)) {
            this.onOutcomeOk(meeting);
            return Args.create();
        }
        if ("fail".equals(eventName)) {
            String code = ArgTools.getString((IArgs)args, (String)"error.code", (String)"unknown");
            String message = ArgTools.getString((IArgs)args, (String)"error.message", (String)"unknown exception event");
            this.onOutcomeFail(meeting, code, message);
            return Args.create();
        }
        if ("cancel".equals(eventName)) {
            this.onOutcomeCancel(meeting);
            return Args.create();
        }
        meeting.postEvent(eventName, args);
        return Args.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map onSetResult(IArgs value) throws Exception {
        BridgletHandler bridgletHandler = this;
        synchronized (bridgletHandler) {
            this.result = this.result == null ? value : ArgTools.putAll((IArgs)this.result, (IArgs)value);
        }
        return new HashMap();
    }

    @Override
    public void onUnregistered(IMeeting meeting) {
        if (!meeting.isStateClosed()) {
            this.onOutcomeFail(meeting, "RegistryTimeout", "The meeting is terminated because of a registry timeout condition");
        }
    }
}

