/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.bridglet;

import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ClassLoaderTools;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgletLicenseTools {
    private static final Logger Log = LoggerFactory.getLogger(BridgletLicenseTools.class);
    private static final String PRODUCT_BRIDGE = "de.intarsys.stage.product.bridge";
    private static final Collection<License> LICENSES;
    private static final ILocator LICENSES_SERIALIZED;

    private static ILocator createLicensesSerialized(Collection<License> additionalLicenses) {
        LicenseRepository repository = new LicenseRepository(null);
        LICENSES.forEach(license -> repository.addLicense(license));
        additionalLicenses.forEach(license -> repository.addLicense(license));
        ByteArrayLocator locator = new ByteArrayLocator("license.lic");
        try {
            LicenseTools.saveRepository((LicenseRepository)repository, (ILocator)locator);
        }
        catch (IOException ex) {
            Log.warn(ex.getMessage(), (Throwable)ex);
        }
        return locator;
    }

    public static ILocator getLicenses(Collection<License> additionalLicenses) {
        if (additionalLicenses.isEmpty()) {
            return LICENSES_SERIALIZED;
        }
        return BridgletLicenseTools.createLicensesSerialized(additionalLicenses);
    }

    private static Collection<License> loadDemoLicenses() {
        ClassLoaderResourceLocator locator = new ClassLoaderResourceLocator(ClassLoaderTools.defaultClassLoader(), "bridge-test.lic");
        try {
            return LicenseTools.loadLicense((ILocator)locator);
        }
        catch (LicenseException ex) {
            Log.warn(ex.getMessage(), (Throwable)ex);
            return Collections.emptySet();
        }
    }

    static {
        Stream<Object> stream = LicenseEnvironment.get().getLicenses().stream();
        stream = Stream.concat(stream, BridgletLicenseTools.loadDemoLicenses().stream());
        LICENSES = stream.filter(license -> PRODUCT_BRIDGE.equals(license.getProductId())).filter(license -> license.isValidPeriod()).collect(Collectors.toUnmodifiableSet());
        LICENSES_SERIALIZED = BridgletLicenseTools.createLicensesSerialized(Collections.emptySet());
    }
}

