/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.core;

import de.intarsys.cloudsuite.meeting.core.AbstractMessage;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsMeeting;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsParticipant;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingRegistry;
import de.intarsys.cloudsuite.meeting.core.IMessageChannelFactory;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.core.MeetingInfo;
import de.intarsys.cloudsuite.meeting.core.ParticipantInfo;
import de.intarsys.tools.functor.IArgs;

public class CtrlMeeting {
    private IMeetingRegistry meetingRegistry;
    private IMessageChannelFactory messageChannelFactory;

    public CtrlMeeting(IMeetingRegistry meetingRegistry, IMessageChannelFactory messageChannelFactory) {
        this.messageChannelFactory = messageChannelFactory;
        this.meetingRegistry = meetingRegistry;
    }

    public Object call(MeetingInfo meetingInfo, ParticipantInfo participantInfo, String method, IArgs args) throws Exception {
        IMeeting meeting = this.lookupMeeting(meetingInfo);
        IParticipant participant = this.lookupParticipant(meeting, participantInfo);
        return meeting.call(participant, method, args);
    }

    public ConnectOptionsMeeting connect(MeetingInfo meetingInfo, ParticipantInfo participantInfo, ConnectOptionsParticipant options) {
        IMeeting meeting = this.lookupMeeting(meetingInfo);
        if (participantInfo == null) {
            throw new IllegalArgumentException("participantInfo is required");
        }
        String id = participantInfo.getId();
        if (id == null) {
            throw new IllegalArgumentException("participantInfo.id is required");
        }
        if (options == null) {
            options = new ConnectOptionsParticipant();
        }
        if (options.getMessageChannel() == null) {
            options.setMessageChannel(this.messageChannelFactory.createMessageChannel());
        }
        return meeting.connect(participantInfo, options);
    }

    public void disconnect(MeetingInfo meetingInfo, ParticipantInfo participantInfo) {
        IMeeting meeting = this.lookupMeeting(meetingInfo);
        IParticipant participant = this.lookupParticipant(meeting, participantInfo);
        meeting.disconnect(participant);
    }

    public AbstractMessage fetchMessage(MeetingInfo meetingInfo, ParticipantInfo participantInfo) {
        IMeeting meeting = this.lookupMeeting(meetingInfo);
        IParticipant participant = this.lookupParticipant(meeting, participantInfo);
        AbstractMessage msg = meeting.fetchMessage(participant);
        return msg;
    }

    public IMeetingRegistry getMeetingRegistry() {
        return this.meetingRegistry;
    }

    public IMessageChannelFactory getMessageChannelFactory() {
        return this.messageChannelFactory;
    }

    protected IMeeting lookupMeeting(MeetingInfo meetingInfo) {
        if (meetingInfo == null) {
            throw new IllegalArgumentException("meetingInfo required");
        }
        if (meetingInfo.getId() == null) {
            throw new IllegalArgumentException("meetingInfo.id required");
        }
        IMeeting meeting = this.meetingRegistry.lookupMeeting(meetingInfo.getId());
        if (meeting == null) {
            throw new IllegalArgumentException("meeting '" + meetingInfo.getId() + "' not found");
        }
        return meeting;
    }

    protected IParticipant lookupParticipant(IMeeting meeting, ParticipantInfo participantInfo) {
        if (participantInfo == null) {
            throw new IllegalArgumentException("participantInfo required");
        }
        if (participantInfo.getId() == null) {
            throw new IllegalArgumentException("participantInfo.id required");
        }
        IParticipant participant = meeting.lookupParticipant(participantInfo.getId());
        if (participant == null) {
            throw new IllegalArgumentException("participant '" + participantInfo.getId() + "' not found");
        }
        return participant;
    }
}

