/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.core;

import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingHandler;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.impl.Meeting;
import de.intarsys.tools.functor.IArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MeetingHandlerAdapter
implements IMeetingHandler {
    private static final Logger Log = LoggerFactory.getLogger(MeetingHandlerAdapter.class);

    @Override
    public Object call(IMeeting meeting, IParticipant participant, String name, IArgs args) throws Exception {
        Log.info("{} meeting {} participant {} call {}", new Object[]{this, meeting, participant, name});
        throw new IllegalArgumentException("method '" + name + "' not supported");
    }

    protected boolean checkParticipants(IMeeting meeting) {
        return meeting.getParticipants().size() > 0;
    }

    @Override
    public void onClosed(IMeeting meeting) {
    }

    @Override
    public void onConnect(IMeeting meeting, IParticipant participant) {
        Log.debug("{} meeting {} participant {} will connect", new Object[]{this, meeting, participant});
        ((Meeting)meeting).addParticpant(participant);
        if (this.checkParticipants(meeting)) {
            meeting.toStateConnected();
        }
    }

    @Override
    public void onDisconnected(IMeeting meeting, IParticipant participant) {
        if (!meeting.isStateClosed() && !this.checkParticipants(meeting)) {
            meeting.toStateWaitConnect();
        }
    }

    @Override
    public void onError(IMeeting meeting, String error, String message) {
        Log.debug("{} meeting {} error {}", new Object[]{this, meeting, error});
        meeting.close();
    }

    @Override
    public void onUnregistered(IMeeting meeting) {
        if (!meeting.isStateClosed()) {
            meeting.close();
        }
    }
}

