/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.demo;

import de.intarsys.cloudsuite.meeting.core.CtrlMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingFactory;
import de.intarsys.cloudsuite.meeting.core.IMeetingRegistry;
import de.intarsys.cloudsuite.meeting.core.IMessageChannelFactory;
import de.intarsys.cloudsuite.meeting.demo.DemoMeetingHandler;
import de.intarsys.cloudsuite.meeting.demo.MeetingStub;
import de.intarsys.cloudsuite.meeting.impl.ConversationMeetingFactory;
import de.intarsys.cloudsuite.meeting.impl.QueuedMessageChannelFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public class DemoApp {
    private CtrlMeeting ctrlMeeting;
    private IMeetingFactory meetingFactory;
    private IMessageChannelFactory messageChannelFactory;

    public static void main(String[] args) {
        try {
            new DemoApp().run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected CtrlMeeting createMeeting(IMeetingRegistry meetingRegistry, IMessageChannelFactory messageChannelFactory) {
        return new CtrlMeeting(meetingRegistry, messageChannelFactory);
    }

    protected IMeetingFactory createMeetingFactory() {
        return new ConversationMeetingFactory();
    }

    protected IMessageChannelFactory createMessageChannelFactory() {
        return new QueuedMessageChannelFactory();
    }

    public void run() throws Exception {
        this.messageChannelFactory = this.createMessageChannelFactory();
        this.meetingFactory = this.createMeetingFactory();
        this.ctrlMeeting = this.createMeeting(this.meetingFactory, this.messageChannelFactory);
        IMeeting meeting = this.meetingFactory.createMeeting(new DemoMeetingHandler((IArgs)Args.create()), (IArgs)Args.create());
        MeetingStub s1 = new MeetingStub(this.ctrlMeeting, meeting.getId(), "p1");
        s1.connect();
        MeetingStub s2 = new MeetingStub(this.ctrlMeeting, meeting.getId(), "p2");
        s2.connect();
        Object result = s1.call("foo", (IArgs)Args.create());
    }
}

