/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.demo;

import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.core.MeetingHandlerAdapter;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoMeetingHandler
extends MeetingHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(DemoMeetingHandler.class);
    private final IArgs args;
    private IArgs result;

    public DemoMeetingHandler(IArgs args) {
        this.args = args;
    }

    @Override
    public Object call(IMeeting meeting, IParticipant participant, String name, IArgs args) throws Exception {
        if ("getParameters".equals(name)) {
            return this.onGetParameters();
        }
        if ("postEvent".equals(name)) {
            return this.onPostEvent(meeting, participant, args);
        }
        if ("setResult".equals(name)) {
            return this.onSetResult(args);
        }
        if ("getResult".equals(name)) {
            return this.onGetResult(args);
        }
        return super.call(meeting, participant, name, args);
    }

    protected IArgs createExceptionArgs(String code, String message) {
        Args exArgs = Args.create();
        ArgTools.putPath((IArgs)exArgs, (String)"name", (Object)"fail");
        ArgTools.putPath((IArgs)exArgs, (String)"error.code", (Object)code);
        ArgTools.putPath((IArgs)exArgs, (String)"error.message", (Object)message);
        return exArgs;
    }

    protected IArgs getBridgeArgs() {
        return ArgTools.getArgs((IArgs)this.args, (String)"bridge", (IArgs)Args.create());
    }

    protected IArgs getBridgletArgs() {
        return ArgTools.getArgs((IArgs)this.args, (String)"bridglet", (IArgs)Args.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ILocator getLicense() {
        ByteArrayLocator byteArrayLocator;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/bridge-test.lic");
            byte[] bytes = StreamTools.getBytes((InputStream)is);
            byteArrayLocator = new ByteArrayLocator(bytes, "license.lic");
        }
        catch (IOException e) {
            ILocator iLocator;
            try {
                iLocator = null;
            }
            catch (Throwable throwable) {
                StreamTools.close(is);
                throw throwable;
            }
            StreamTools.close((Closeable)is);
            return iLocator;
        }
        StreamTools.close((Closeable)is);
        return byteArrayLocator;
    }

    protected IArgs onGetParameters() {
        Args params = Args.create();
        IArgs bridgeArgs = this.getBridgeArgs();
        params.put("bridge", (Object)bridgeArgs);
        ArgTools.putPathIfAbsent((IArgs)bridgeArgs, (String)"license", (Object)this.getLicense());
        IArgs bridgletSpec = this.getBridgletArgs();
        params.put("bridglet", (Object)bridgletSpec);
        return params;
    }

    protected IArgs onGetResult(IArgs args) {
        return this.result;
    }

    protected Object onOutcome(IMeeting meeting, IParticipant participant, IArgs args) throws Exception {
        String state = ArgTools.getString((IArgs)args, (String)"name", null);
        IArgs forwardArgs = null;
        try {
            if ("ok".equals(state)) {
                forwardArgs = this.onOutcomeOk(meeting, participant, args);
            } else if ("fail".equals(state)) {
                forwardArgs = this.onOutcomeFail(meeting, participant, args);
            } else if ("cancel".equals(state)) {
                forwardArgs = this.onOutcomeCancel(meeting, participant);
            } else {
                throw new IllegalArgumentException("state '" + state + "' not supported");
            }
            Args args2 = Args.create();
            this.onOutcomeFinally(meeting, state, forwardArgs);
            return args2;
        }
        catch (Exception e) {
            try {
                forwardArgs = this.createExceptionArgs("unknown", ExceptionTools.getMessage((Throwable)e));
                throw e;
            }
            catch (Throwable throwable) {
                this.onOutcomeFinally(meeting, state, forwardArgs);
                throw throwable;
            }
        }
    }

    protected IArgs onOutcomeCancel(IMeeting meeting, IParticipant participant) {
        return Args.create();
    }

    protected IArgs onOutcomeFail(IMeeting meeting, IParticipant participant, IArgs pArgs) {
        String message;
        String code;
        if (pArgs == null) {
            code = "unknown";
            message = "unknown exception event";
        } else {
            code = ArgTools.getString((IArgs)pArgs, (String)"error.code", (String)"unknown");
            message = ArgTools.getString((IArgs)pArgs, (String)"error.message", (String)"unknown exception event");
        }
        return this.createExceptionArgs(code, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOutcomeFinally(IMeeting meeting, String state, IArgs forwardArgs) {
        try {
            String forwardState = ArgTools.getString((IArgs)forwardArgs, (String)"name", (String)state);
            meeting.postEvent(forwardState, forwardArgs);
        }
        finally {
            meeting.close();
        }
    }

    protected IArgs onOutcomeOk(IMeeting meeting, IParticipant participant, IArgs args) throws Exception {
        return Args.create();
    }

    protected Object onPostEvent(IMeeting meeting, IParticipant participant, IArgs args) throws Exception {
        String eventName = ArgTools.getString((IArgs)args, (String)"name", null);
        if ("ok".equals(eventName)) {
            return this.onOutcome(meeting, participant, args);
        }
        if ("fail".equals(eventName)) {
            return this.onOutcome(meeting, participant, args);
        }
        if ("cancel".equals(eventName)) {
            return this.onOutcome(meeting, participant, args);
        }
        meeting.postEvent(eventName, args);
        return Args.create();
    }

    protected Map onSetResult(IArgs value) throws Exception {
        this.result = this.result == null ? value : ArgTools.putAll((IArgs)this.result, (IArgs)value);
        return new HashMap();
    }
}

